<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.imagesSlider') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/images-slider-list') ?>" class="dropdown-item"><?= lang('Dashboard.imagesSliderList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-add-image-slider') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= old('title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="description" class="col-sm-3 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="description" id="description" placeholder="<?= lang('Dashboard.description') ?>" value="<?= old('description') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="url" class="col-sm-3 col-form-label"><?= lang('Dashboard.url') ?></label>
                                        <div class="col-sm-9">
                                            <input type="url" class="form-control" name="url" id="url" placeholder="<?= lang('Dashboard.url') ?> (<?= lang('Dashboard.optional') ?>)" value="<?= old('url') ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="type_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.sliderType') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="type_id" id="type_id" required>
                                                <?php
                                                foreach ($imagesSliderTypes as $imagesSliderType)
                                                {
                                                ?>
                                                    <option value="<?= $imagesSliderType->id ?>"><?= $imagesSliderType->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="type_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.genre') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="category_type_id" id="category_type_id" required>
                                                <?php
                                                foreach ($categoriesTypes as $genre)
                                                {
                                                ?>
                                                    <option value="<?= $genre->id ?>"><?= $genre->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="blog_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.contentId') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="blog_id" id="blog_id" value="<?= old('blog_id') ?>" required>
                                            <small class="text-info"><?= lang('Dashboard.enterAppsOrGamesOrBlogId') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.enterZeroToOpenAboveURL') ?></small>
                                        </div>
                                    </div>

                                    <!--<div class="form-group row">
                                        <label for="blog_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.blogPost') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="blog_id" id="blog_id" required>
                                                <option value="0" selected><?= lang('Dashboard.openTheAboveURL') ?></option>
                                                <?php
                                                foreach ($blogPosts as $blogPost)
                                                {
                                                ?>
                                                    <option value="<?= $blogPost->id ?>"><?= $blogPost->title ?></option>
                                                <?php 
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>-->

                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?> *</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 1920, 800 ]) ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]) ?></small>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="status" checked type="checkbox"> <?= lang('Dashboard.enableThisImageSlider') ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.submit') ?>"><?= lang('Dashboard.submit') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.submit') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                                <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeCreatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>