<?php

namespace Modules\Addons\ImageSlider\Controllers\Backend;

use Modules\Addons\ImageSlider\Models\Backend\ImageSliderModel;
use App\Controllers\BaseController;

class ImageSliderController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
        $this->imageSliderModel = new ImageSliderModel();
    }


    //===========================================================//
    public function images_slider_list()
    {
        $locale = $this->session->lang;
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'imagesSlider' => $this->imageSliderModel
                    ->select('images_slider_tbl.*, images_slider_types_tbl.title AS type_title, categories_types_tbl.title AS category_type_title')
                    ->Where('images_slider_tbl.locale', $locale)
                    ->join('images_slider_types_tbl', 'images_slider_types_tbl.id = images_slider_tbl.type_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = images_slider_tbl.category_type_id')
                    ->orderBy('images_slider_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->imageSliderModel->pager
            ];

        }else{
            $data = [
                'imagesSlider' => $this->imageSliderModel
                    ->select('images_slider_tbl.*, images_slider_types_tbl.title AS type_title, categories_types_tbl.title AS category_type_title')
                    ->Where('images_slider_tbl.locale', $locale)
                    ->like('images_slider_tbl.title',$keyword)
                    ->orLike('images_slider_tbl.description',$keyword)
                    ->orLike('images_slider_types_tbl.title',$keyword)
                    ->join('images_slider_types_tbl', 'images_slider_types_tbl.id = images_slider_tbl.type_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = images_slider_tbl.category_type_id')
                    ->orderBy('images_slider_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->imageSliderModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.imagesSliderList');
        $data['pageSubTitle'] = lang('Dashboard.imagesSliderList');
        return view('\Modules\Addons\ImageSlider\Views\backend\images_slider\images_slider_list_view', $data);
    }


    //===========================================================//
    public function add_image_slider()
    {
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch image slider types
        $builder = $db->table('images_slider_types_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['imagesSliderTypes'] = $builder->get()->getResult();

        // Fetch category types (Genre)
        $builder = $db->table('categories_types_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['categoriesTypes'] = $builder->get()->getResult();

        // Fetch blog posts
        $builder = $db->table('blog_tbl');
        $builder->select('id, title');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['blogPosts'] = $builder->get()->getResult();

        $db->close();

        $data['pageTitle'] = lang('Dashboard.addImageSlider');
        $data['pageSubTitle'] = lang('Dashboard.addImageSlider');
        return view('\Modules\Addons\ImageSlider\Views\backend\images_slider\add_image_slider_view', $data);
    }



    //===========================================================//
    public function perform_add_image_slider()
    {
        // Validation the form
        $rules = [
            'title'             => 'required|min_length[2]|max_length[255]',
            'description'       => 'required|min_length[2]|max_length[255]',
            'url'               => 'permit_empty|max_length[255]',
            'type_id'           => 'required|integer',
            'category_type_id'  => 'required|integer',
            'blog_id'           => 'required|integer',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,500]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/add-image-slider"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $url = $this->request->getVar('url');
        $blog_id = $this->request->getVar('blog_id');
        if ($blog_id == 0 AND $url == "") {
            return redirect()->to(base_url("dashboard/add-image-slider"))->withInput()->with('error', lang('Dashboard.youDidNotSelectBlogPostSoYouShouldEnterURL'));
        }

        $newName = "slider.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/images_slider/', $newName);

            $imgPath = $img->getTempName();
            $imgQuality = 90;
            $watermark = "";
            $image = \Config\Services::image()
                ->withFile($imgPath.$newName)
                ->text($watermark, [
                    'color'      => '#f9f9f9',
                    'opacity'    => 0.7,
                    'withShadow' => false,
                    'hAlign'     => 'center', /* hAlign Horizontal alignment: left, center, right */
                    'vAlign'     => 'middle', /* vAlign Vertical alignment: top, middle, bottom */
                    'fontSize'   => 25,
                    'fontPath'   => ''
                ])
                ->fit(1920, 800, 'center')
                ->save('./backend/assets/uploads/admins/modules/images_slider/'.$newName, $imgQuality);
        }

        $status = 0;
        if($this->request->getVar('status') == "on") $status = 1;

        $data = [
            'title'             => $this->request->getVar('title'),
            'description'       => $this->request->getVar('description'),
            'url'               => $this->request->getVar('url'),
            'type_id'           => $this->request->getVar('type_id'),
            'category_type_id'  => $this->request->getVar('category_type_id'),
            'blog_id'           => $this->request->getVar('blog_id'),
            'locale'            => $this->session->lang,
            'image'             => $newName,
            'status'            => $status,
        ];
        $this->imageSliderModel->save($data);

        return redirect()->to(base_url("dashboard/images-slider-list"))->with('success', lang('Dashboard.imageSliderAddedSuccessfully'));
    }



    //===========================================================//
    public function delete_image_slider()
    {
        // Check image slider exist
        $id = service('uri')->getSegment(3);
        $imageSlider = $this->imageSliderModel->where('id', $id)->first();
        if(is_null($imageSlider))
        {
            return redirect()->to(base_url('dashboard/images-slider-list'))->with('error', lang('Dashboard.notFound'));

        }else{
            // Delete image slider
            $this->imageSliderModel->delete($id);

            // Remove image from disk
            if($imageSlider->image != 'slider.png')
                @unlink('./backend/assets/uploads/admins/modules/images_slider/'.$imageSlider->image);

            return redirect()->to(base_url('dashboard/images-slider-list'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }


    //===========================================================//
    public function edit_image_slider()
    {
        $id = service('uri')->getSegment(3);
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch image slider types
        $builder = $db->table('images_slider_types_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['imagesSliderTypes'] = $builder->get()->getResult();

        // Fetch category types (Genre)
        $builder = $db->table('categories_types_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['categoriesTypes'] = $builder->get()->getResult();

        // Fetch blog posts
        $builder = $db->table('blog_tbl');
        $builder->select('id, title');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['blogPosts'] = $builder->get()->getResult();

        $db->close();

        $data['imageSlider'] = $this->imageSliderModel->select('images_slider_tbl.*')
            ->where('images_slider_tbl.id', $id)
            ->first();

        $data['pageTitle'] = lang('Dashboard.editImageSlider');
        $data['pageSubTitle'] = lang('Dashboard.editImageSlider');
        return view('\Modules\Addons\ImageSlider\Views\backend\images_slider\edit_image_slider_view', $data);
    }


    //===========================================================//
    public function perform_edit_image_slider()
    {
        $id = $this->request->getVar('id');
        $old_image = $this->request->getVar('old_image');
        // Validation the form
        $rules = [
            'id'                => 'required|integer',
            'old_image'         => 'required',
            'title'             => 'required|min_length[2]|max_length[255]',
            'description'       => 'required|min_length[2]|max_length[255]',
            'url'               => 'permit_empty|max_length[255]',
            'type_id'           => 'required|integer',
            'category_type_id'  => 'required|integer',
            'blog_id'           => 'required|integer',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,500]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/edit-image-slider/$id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $newName = "slider.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/images_slider/', $newName);

            $imgPath = $img->getTempName();
            $imgQuality = 90;
            $watermark = "";
            $image = \Config\Services::image()
                ->withFile($imgPath.$newName)
                ->text($watermark, [
                    'color'      => '#f9f9f9',
                    'opacity'    => 0.7,
                    'withShadow' => false,
                    'hAlign'     => 'center', /* hAlign Horizontal alignment: left, center, right */
                    'vAlign'     => 'middle', /* vAlign Vertical alignment: top, middle, bottom */
                    'fontSize'   => 25,
                    'fontPath'   => ''
                ])
                ->fit(1920, 800, 'center')
                ->save('./backend/assets/uploads/admins/modules/images_slider/'.$newName, $imgQuality);
        }


        $status = 0;
        if($this->request->getVar('status') == "on") $status = 1;

        if($img != "")
        {
            // Update image slider with image and delete old image
            $data = [
                'id' => $this->request->getVar('id'),
                'title' => $this->request->getVar('title'),
                'description' => $this->request->getVar('description'),
                'url' => $this->request->getVar('url'),
                'type_id' => $this->request->getVar('type_id'),
                'category_type_id' => $this->request->getVar('category_type_id'),
                'blog_id' => $this->request->getVar('blog_id'),
                'locale' => $this->session->lang,
                'status' => $status,
                'image' => $newName,
            ];
            $this->imageSliderModel->save($data);

            // Remove old image from disk
            if($old_image != 'slider.png')
                @unlink('./backend/assets/uploads/admins/modules/images_slider/'.$old_image);

        }else{
            // Update slider image without image
            $data = [
                'id' => $this->request->getVar('id'),
                'title' => $this->request->getVar('title'),
                'description' => $this->request->getVar('description'),
                'url' => $this->request->getVar('url'),
                'type_id' => $this->request->getVar('type_id'),
                'category_type_id' => $this->request->getVar('category_type_id'),
                'blog_id' => $this->request->getVar('blog_id'),
                'locale' => $this->session->lang,
                'status' => $status,
            ];
            $this->imageSliderModel->save($data);
        }

        return redirect()->to(base_url("dashboard/images-slider-list"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }

}
