<?php

use App\Models\Backend\CategoryModel;
$categoryModel = new CategoryModel();

?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.downloadManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-gray card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/pending-contents-reviews-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th style="min-width: 158px;"><?= lang('Dashboard.author') ?></th>
                                        <th><?= lang('Dashboard.file') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.description') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.rating') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th style="min-width: 128px;"><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($contentsReviews as $review)
                                    {
                                        $author_ip = $review->author_ip;
                                        if($theRoleID == 9)
                                            $author_ip = 'xx.xx.xx.xx';

                                        $approved = "<span class='badge badge-warning'>".lang('Dashboard.unapproved')."</span>";
                                        if($review->approved == 0) $approved = "<span class='center badge badge-warning'>".lang('Dashboard.unapproved')."</span>";
                                        if($review->approved == 1) $approved = "<span class='center badge badge-success'>".lang('Dashboard.approved')."</span>";
                                        if($review->approved == 2) $approved = "<span class='center badge bg-gray'>".lang('Dashboard.pending')."</span>";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><a href="<?= base_url("dashboard/user-profile/$review->user_id") ?>"><?= $review->first_name." ".$review->last_name ?></a></td>
                                            <td class="align-middle"><a href="<?= base_url("dashboard/edit-game-file/$review->content_id") ?>"><?= $review->content_title ?></a></td>
                                            <td class="align-middle"><?= $review->title ?></td>
                                            <td class="align-middle"><?= $review->description ?></td>
                                            <td class="align-middle"><?= $author_ip ?></td>
                                            <td class="align-middle"><?= $review->rating ?> <i class="fas fa-star fa-sm text-yellow"></i></td>
                                            <td class="align-middle"><?= $approved ?></td>
                                            <td class="align-middle" style="width: 128px;">
                                                <a target="_blank" title="<?= lang('Dashboard.viewFile') ?>" href="<?= base_url("file-details/$review->content_id/file") ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>
                                                <a title="<?= lang('Dashboard.approve') ?>" href="<?= base_url('dashboard/approve-contents-review/'.$review->id) ?>" class="text-success p-1"><i class="fas fa-check"></i></a>&nbsp;
                                                <a title="<?= lang('Dashboard.unapproved') ?>" href="<?= base_url('dashboard/unapproved-contents-review/'.$review->id) ?>" class="text-danger p-1"><i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($contentsReviews)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>