<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('tags-input-header') ?>
<!-- Tags Input: https://github.com/erwinheldy/tagin -->
    <link rel="stylesheet" href="<?= base_url('backend/assets/dist/css/tagin/tagin.min.css'); ?>">
<?= $this->endSection() ?>

<?= $this->section('tags-input-footer') ?>
    <!-- Tags Input -->
    <script src="<?= base_url('backend/assets/dist/js/tagin/tagin.min.js'); ?>"></script>
    <script>
        document.querySelectorAll('.tagin:not([id])').forEach((el) => {
            if (el instanceof HTMLInputElement) {
                const tagin = new Tagin(el)
            }
        })

        const testAdd = new Tagin(document.getElementById('test-add'))
        document.getElementById('add1').addEventListener('click', function () {
            testAdd.addTag('yellow')
            this.remove()
        })
        document.getElementById('add2').addEventListener('click', function () {
            testAdd.addTag(['cyan', 'black'])
            this.remove()
        })

        const testValue = new Tagin(document.getElementById('test-value'))
        document.getElementById('get').addEventListener('click', function () {
            const value = testValue.getTag()
            const values = JSON.stringify(testValue.getTags())
            document.getElementById('value-container').innerHTML = `${value}<br>${values}`
        })


        // Example starter JavaScript for disabling form submissions if there are invalid fields
        void (function() {
            document.querySelectorAll('.needs-validation').forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }

                    form.classList.add('was-validated')
                })
            })
        })()
    </script>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.downloadManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-file-user') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                    <?= csrf_field() ?>
                <div class="row">
                    <div class="col-md-9">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/files-list') ?>" class="dropdown-item"><?= lang('Dashboard.filesList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>

                                <div class="card-body">

                                <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.title') ?> *</label>
                                                <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= $content->title ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.titleSlug') ?> *</label>
                                                <input type="text" class="form-control" name="title_slug" id="title_slug" placeholder="<?= lang('Dashboard.titleSlug') ?>" value="<?= $content->title_slug ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.aboutFile') ?> *</label>
                                                <br>
                                                <textarea name="about_content" id="summernote" required><?= $content->about_content ?></textarea>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.latestChangelog') ?></label>
                                                <br>
                                                <textarea name="latest_changelog" id="summernote2"><?= $content->latest_changelog ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <hr>
                                    <br>

                                    <div class="row">
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.packageName') ?></label>
                                                <input type="text" class="form-control" name="package_name" id="package_name" placeholder="com.package.name" value="<?= $content->package_name ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.versionCode') ?> *</label>
                                                <input type="text" class="form-control" name="version_code" id="version_code" placeholder="1" value="<?= $content->version_code ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.versionName') ?> *</label>
                                                <input type="text" class="form-control" name="version_name" id="version_name" placeholder="1.0.0" value="<?= $content->version_name ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.volume') ?> *</label>
                                                <input dir="ltr" type="text" class="form-control" name="volume" id="volume" placeholder="12.35 MB" value="<?= $content->volume ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.publisherName') ?> *</label>
                                                <input type="text" class="form-control" name="publisher_name" id="publisher_name" placeholder="<?= lang('Dashboard.exGoogle') ?>" value="<?= $content->publisher_name ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.publisherUrl') ?> *</label>
                                                <input dir="ltr" type="url" class="form-control" name="publisher_url" id="publisher_url" placeholder="<?= lang('Dashboard.www.Google.com') ?>" value="<?= $content->publisher_url ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.systemRequirements') ?> *</label>
                                                <input type="text" class="form-control" name="system_requirements" id="system_requirements" placeholder="example: Android 7+" value="<?= $content->system_requirements ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.downloadURL') ?> *</label>
                                                <input type="text" class="form-control" name="download_url" id="download_url" placeholder="https://www.domain.com/release.apk" value="<?= $content->download_url ?>" required>
                                                <small class="text-info"><?= lang('Dashboard.directUrlOfFileToDownload') ?></small>
                                            </div>
                                        </div>
                                    </div>

                                    <hr>
                                    <br>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="description" class="col-sm-2 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="description" id="description" placeholder="<?= lang('Dashboard.description') ?>" value="<?= $content->description ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaDescriptionText') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="keywords" class="col-sm-2 col-form-label"><?= lang('Dashboard.keywords') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="keywords" data-tagin-enter placeholder="<?= lang('Dashboard.keywords') ?>" data-tagin-placeholder="<?= lang('Dashboard.keywords').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= $content->keywords ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaKeywords') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="tags" class="col-sm-2 col-form-label"><?= lang('Dashboard.tags') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="tags" data-tagin-enter placeholder="<?= lang('Dashboard.tags') ?>" data-tagin-placeholder="<?= lang('Dashboard.tags').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= $content->tags ?>">
                                                    <small class="text-info"><?= lang('Dashboard.separateWithAComma') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-3">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.contentSettings'); ?></h3>
                                <div class="card-tools">
                                </div>
                            </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12">

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.contentStructure') ?> *</label>
                                                <select class="form-control" name="structure_id" id="structure_id" required>
                                                    <?php
                                                    foreach ($contentStructure as $structure)
                                                    {
                                                        $structure_selected = "";
                                                        if($content->structure_id == $structure->id)
                                                            $structure_selected = "selected";
                                                        ?>
                                                        <option <?= $structure_selected ?> value="<?= $structure->id ?>"><?= $structure->title ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                    
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.category') ?> *</label>
                                                <select class="form-control select2bs4" name="category_id" id="category_id" required>
                                                    <option value="" disabled selected><?= lang('Dashboard.pleaseSelect') ?></option>
                                                    <?php
                                                    foreach ($contentMainCategories as $mainCategory)
                                                    {
                                                        $main_category_selected = "";
                                                        if($content->category_id == $mainCategory->id)
                                                            $main_category_selected = "selected";
                                                    ?>
                                                        <option <?= $main_category_selected ?> value="<?= $mainCategory->id ?>">◼ <?= $mainCategory->title ?></option>
                                                        <?php
                                                        //To get sub category 1
                                                        $db = db_connect();
                                                        $builder = $db->table('categories_tbl');
                                                        $builder->where('locale', $locale);
                                                        $builder->where('status', 1);
                                                        $builder->where('parent_id', $mainCategory->id);
                                                        $builder->where('deleted_at', NULL);
                                                        $builder->where('type_id', $typeId);
                                                        $subCategory1 = $builder->get()->getResult();
                                                        foreach($subCategory1 as $sKey1)
                                                        {
                                                            $sub1_category_selected = "";
                                                            if($content->category_id == $sKey1->id)
                                                            $sub1_category_selected = "selected";

                                                            echo "<option $sub1_category_selected value='$sKey1->id'>&nbsp;&nbsp;&nbsp;&nbsp;◾&nbsp;$sKey1->title</option>";

                                                            //To get sub sub category 2
                                                            $builder->where('parent_id', $sKey1->id);
                                                            $builder->where('type_id', $typeId);
                                                            $builder->where('deleted_at', NULL);
                                                            $subSubCategory2 = $builder->get()->getResult();
                                                            foreach($subSubCategory2 as $ssKey2)
                                                            {
                                                                $sub2_category_selected = "";
                                                                if($content->category_id == $ssKey2->id)
                                                                $sub2_category_selected = "selected";

                                                                echo "<option $sub2_category_selected value='$ssKey2->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◆&nbsp;$ssKey2->title</option>";

                                                                //To get sub sub sub category 3
                                                                $builder->where('parent_id', $ssKey2->id);
                                                                $builder->where('type_id', $typeId);
                                                                $builder->where('deleted_at', NULL);
                                                                $subSubCategory3 = $builder->get()->getResult();
                                                                foreach($subSubCategory3 as $sssKey3)
                                                                {
                                                                    $sub3_category_selected = "";
                                                                    if($content->category_id == $sssKey3->id)
                                                                    $sub3_category_selected = "selected";

                                                                    echo "<option $sub3_category_selected value='$sssKey3->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◈&nbsp;$sssKey3->title</option>";

                                                                    //To get sub sub sub sub category 4
                                                                    $builder->where('parent_id', $sssKey3->id);
                                                                    $builder->where('type_id', $typeId);
                                                                    $builder->where('deleted_at', NULL);
                                                                    $subSubCategory4 = $builder->get()->getResult();
                                                                    foreach($subSubCategory4 as $ssssKey4)
                                                                    {
                                                                        $sub4_category_selected = "";
                                                                        if($content->category_id == $ssssKey4->id)
                                                                        $sub4_category_selected = "selected";

                                                                        echo "<option $sub4_category_selected value='$ssssKey4->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◇&nbsp;$ssssKey4->title</option>";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $db->close();
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.downloadType') ?> *</label>
                                                <select class="form-control" name="download_type" id="download_type" required>
                                                    <?php
                                                    $free_selected = $paid_selected = $inapp_selected = "";
                                                    if($content->download_type == 1)
                                                        $free_selected = "selected";
                                                    if($content->download_type == 2)
                                                        $paid_selected = "selected";
                                                    if($content->download_type == 3)
                                                        $inapp_selected = "selected";
                                                    ?>
                                                    <option <?= $free_selected ?> value="1"><?= lang('Dashboard.free') ?></option>
                                                    <!--<option <?= $paid_selected ?> value="2"><?= lang('Dashboard.paid') ?></option>-->
                                                    <option <?= $inapp_selected ?> value="3"><?= lang('Dashboard.inAppPurchase') ?></option>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.userRole') ?> *</label>
                                                <?php
                                                    $not_registered_user_selected = $regular_user_selected = $vip_user_selected = "";
                                                    if($content->role_id == 0)
                                                        $not_registered_user_selected = "selected";
                                                    if($content->role_id == 10)
                                                        $regular_user_selected = "selected";
                                                    if($content->role_id == 11)
                                                        $vip_user_selected = "selected";
                                                    ?>
                                                <select class="form-control" name="role_id" id="role_id" required>
                                                    <option value="0" <?= $not_registered_user_selected  ?>><?= lang('Dashboard.accessForAllUsersAndGuest') ?></option>
                                                    <option value="10" <?= $regular_user_selected  ?>><?= lang('Dashboard.accessForAllRegisteredUsers') ?></option>
                                                    <option value="11" <?= $vip_user_selected  ?>><?= lang('Dashboard.accessForVipUsersOnly') ?></option>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.mainImage') ?></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image">
                                                        <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                    </div>
                                                </div>
                                                <small class="text-info"><?= lang('Dashboard.theBestImageRatioShouldBe',[512, 512]) ?></small>
                                            </div>

                                            <div class="form-group">
                                                
                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $allow_comments_checked = "";
                                                            if($content->allow_comments == 1)
                                                                $allow_comments_checked = "checked";
                                                            ?>
                                                            <input <?= $allow_comments_checked ?> name="allow_comments" type="checkbox"> <?= lang('Dashboard.allowComments') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $allow_reviews_checked = "";
                                                            if($content->allow_reviews == 1)
                                                                $allow_reviews_checked = "checked";
                                                            ?>
                                                            <input <?= $allow_reviews_checked ?> name="allow_reviews" type="checkbox"> <?= lang('Dashboard.allowReviews') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $install_after_downloading_checked = "";
                                                            if($content->install_after_downloading == 1)
                                                                $install_after_downloading_checked = "checked";
                                                            ?>
                                                            <input <?= $install_after_downloading_checked ?> name="install_after_downloading" type="checkbox"> <?= lang('Dashboard.installAfterDownloading') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                            </div>

                                            <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeUpdatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>
                                            
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    <?php
                                    $session = session();
                                    $role_id = $session->role_id;
                                    if($role_id != 9 AND $role_id != 19)
                                    {
                                        ?>
                                        <input type="hidden" name="id" value="<?= $content->id ?>" readonly>
                                        <input type="hidden" name="old_image" value="<?= $content->image ?>" readonly>
                                        <input type="hidden" name="status" value="0" readonly>
                                        <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.editFile') ?>"><?= lang('Dashboard.editFile') ?></button>
                                        <?php
                                    }else{
                                        ?>
                                        <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.editFile') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <!-- /.card-footer-->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
            </form>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>