<?php
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.downloadManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/downloaded-files') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                <table class="table table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.id') ?></th>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.email') ?></th>
                                        <th><?= lang('Dashboard.file') ?></th>
                                        <th><?= lang('Dashboard.device') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.firstDownload') ?></th>
                                        <th><?= lang('Dashboard.lastDownload') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($downloadedFiles as $file)
                                    {
                                        if($settingsData->calendar_type == "jDate")
                                        {
                                            $created_at = $jdf->jdate('Y/m/d G:i', $file->created_at, '', $settingsData->timezone)." <small class='text-info'>(".timespan($file->created_at, time(), 2)." ".lang("Date.ago").")</small>";
                                            $updated_at = $jdf->jdate('Y/m/d G:i', $file->updated_at, '', $settingsData->timezone)." <small class='text-info'>(".timespan($file->updated_at, time(), 2)." ".lang("Date.ago").")</small>";
                                        }else{
                                            $created_at = Time::createFromTimestamp($file->created_at, $settingsData->timezone, 'en_US')." <small class='text-info'>(".timespan($file->created_at, time(), 2)." ".lang("Date.ago").")</small>";
                                            $updated_at = Time::createFromTimestamp($file->updated_at, $settingsData->timezone, 'en_US')." <small class='text-info'>(".timespan($file->updated_at, time(), 2)." ".lang("Date.ago").")</small>";
                                        }
                                        $file_ip = $file->ip;
                                        if($theRoleID == 9)
                                            $file_ip = 'xx.xx.xx.xx';
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $file->id ?></td>
                                            <?php
                                            if($file->user_id != 0) {
                                            ?>
                                            <td class="align-middle"><a href="<?= base_url('dashboard/user-profile/'.$file->user_id) ?>"><?= $file->first_name." ".$file->last_name ?></a></td>
                                            <?php
                                            }else{
                                            ?>
                                            <td class="align-middle"><?= $file->first_name ?></td>
                                            <?php 
                                            } 
                                            ?>
                                            <td class="align-middle"><?= $file->email ?></td>
                                            <td><a target="_blank" title="<?= $file->file_title ?>" href="<?= base_url("file-details/$file->content_id/$file->file_title_slug?id=$file->content_id") ?>"</a><?= $file->file_title ?></td>
                                            <td><?= $file->device_type_title; ?></td>
                                            <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $file_ip ?>" title="<?= $file->agent ?>"><?= $file_ip ?></a></td>
                                            <td><?= $created_at; ?></td>
                                            <td><?= $updated_at; ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($downloadedFiles)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>