<?php

namespace Modules\Addons\Contents\Controllers\Api;

use Modules\Addons\Contents\Models\Backend\ContentModel;
use CodeIgniter\RESTful\ResourceController;
use Modules\Addons\Contents\Models\Backend\ContentReviewModel;
use Modules\Addons\Contents\Models\Backend\ContentReportModel;
use Modules\Addons\Contents\Models\Backend\ContentBookmarkModel;
use Modules\Addons\Contents\Models\Backend\ContentDownloadedModel;
use Modules\Addons\Contents\Models\Backend\ContentImageGalleryModel;
use App\Models\Backend\ApiModel;
use App\Models\Backend\UserModel;

class ApiContentController extends ResourceController
{
    public function __construct()
    {
        $this->session = session();
        $this->contentModel = new ContentModel();
    }


    //===========================================================//
    protected function check_api_key_write($api_id)
    {
        $apiModel = new ApiModel();
        $api = $apiModel->select('api_keys_tbl.*')->where('api_keys_tbl.id', $api_id)->first();

        if($api->write != 1) {
            $msg = array("api_key" => "notWritable");
            $response = [
                'status' => 400,
                "error" => true,
                'messages' => 'Error !',
                'data' => $msg,
            ];

            echo json_encode($response, JSON_UNESCAPED_UNICODE);
            die();

        }
    }


    //===========================================================//
    public function get_all_files()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'structure_id'  => 'required|integer',
            'type_id'       => 'required|integer',
            'keyword'       => 'permit_empty',
            'locale'        => 'required|alpha_dash|min_length[2]|max_length[10]',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $structure_id = $this->request->getVar('structure_id');
        $type_id = $this->request->getVar('type_id');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        if ($last_id == 0) {
            // First Time
            $data['allFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();

        }else{
            // Load More
            $data['allFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.id <', $last_id)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        }

        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'All Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_files_by_category()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'category_id'   => 'required|integer',
            'keyword'       => 'permit_empty',
            'locale'        => 'required|alpha_dash|min_length[2]|max_length[10]',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $category_id = $this->request->getVar('category_id');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        if ($last_id == 0) {
            // First Time
            $data['files'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title')
            ->Where('contents_tbl.category_id', $category_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('contents_tbl.status', 1)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();

        }else{
            // Load More
            $data['files'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title')
            ->Where('contents_tbl.category_id', $category_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.id <', $last_id)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        }
        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_special_files()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'structure_id'  => 'required|integer',
            'type_id'       => 'required|integer',
            'keyword'       => 'permit_empty',
            'locale'        => 'required|alpha_dash|min_length[2]|max_length[10]',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $structure_id = $this->request->getVar('structure_id');
        $type_id = $this->request->getVar('type_id');
        $keyword = $this->request->getVar('keyword');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        if ($last_id == 0) {
            // First Time
            $data['specialFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.special', 1)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();

        }else{
            // Load More
            $data['specialFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.special', 1)
            ->Where('contents_tbl.id <', $last_id)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        }
        
        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Special Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_featured_files()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'structure_id'  => 'required|integer',
            'type_id'       => 'required|integer',
            'keyword'       => 'permit_empty',
            'locale'        => 'required|alpha_dash|min_length[2]|max_length[10]',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $structure_id = $this->request->getVar('structure_id');
        $type_id = $this->request->getVar('type_id');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        if ($last_id == 0) {
            // First Time
            $data['featuredFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.featured', 1)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();

        }else{
            // Load More
            $data['featuredFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->Where('contents_tbl.featured', 1)
            ->Where('contents_tbl.id <', $last_id)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        }

        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Featured Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_files_by_search()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'structure_id'  => 'required|integer',
            'type_id'       => 'required|integer',
            'keyword'       => 'required|min_length[3]|max_length[100]',
            'locale'        => 'required|alpha_dash|min_length[2]|max_length[10]',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $structure_id = $this->request->getVar('structure_id');
        $type_id = $this->request->getVar('type_id');
        $keyword = $this->request->getVar('keyword');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        if ($last_id == 0) {
            // First Time
            $data['searchFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('contents_tbl.status', 1)
            ->like('contents_tbl.title',$keyword)
            /*->orLike('contents_tbl.about_content',$keyword)
            ->orLike('contents_tbl.description',$keyword)
            ->orLike('contents_tbl.keywords',$keyword)
            ->orLike('contents_tbl.publisher_name',$keyword)
            ->orLike('categories_types_tbl.title',$keyword)*/
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        
        }else{
            // Load More
            $data['searchFiles'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.structure_id', $structure_id)
            ->Where('contents_tbl.locale', $locale)
            ->Where('categories_types_tbl.id', $type_id)
            ->Where('contents_tbl.status', 1)
            ->like('contents_tbl.title',$keyword)
            /*->orLike('contents_tbl.about_content',$keyword)
            ->orLike('contents_tbl.description',$keyword)
            ->orLike('contents_tbl.keywords',$keyword)
            ->orLike('contents_tbl.publisher_name',$keyword)
            ->orLike('categories_types_tbl.title',$keyword)*/
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->limit($limit)
            ->orderBy('contents_tbl.id', 'DESC')
            ->get()->getResult();
        }
        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Search Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_one_file()
    {
        $rules = [
            'api_id'    => 'required|integer',
            'api_key'   => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'id'        => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $this->contentImageGalleryModel = new ContentImageGalleryModel();
        $api_id = $this->request->getVar('api_id');
        $id = $this->request->getVar('id');

        $data['fileDetails'] = $this->contentModel->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
            ->Where('contents_tbl.id', $id)
            ->Where('contents_tbl.status', 1)
            ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
            ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
            ->get()->getResult();
        $this->contentReviewModel = new ContentReviewModel();
        $data['totalReviews'] = $this->contentReviewModel->where('content_id', $id)->where('approved', 1)->where('deleted_at', null)->countAllResults();
        $data['totalRatingsSum'] = $this->contentReviewModel->where('content_id', $id)->where('approved', 1)->where('deleted_at', null)->selectSum('rating', 'total_ratings_sum')->get()->getRow()->total_ratings_sum;
        if(isset($data['totalRatingsSum']))
            $data['starsAverage'] = round($data['totalRatingsSum'] / $data['totalReviews'], 1);
        else
            $data['starsAverage'] = 0;
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $data['images'] = $this->contentImageGalleryModel->select('contents_images_gallery_tbl.*')->where('contents_images_gallery_tbl.content_id', $id)->get()->getResult();

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'File Details',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_images_gallery()
    {
        $rules = [
            'api_id'    => 'required|integer',
            'api_key'   => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'id'        => 'required|integer',
        ];
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $this->contentImageGalleryModel = new ContentImageGalleryModel();
        $api_id = $this->request->getVar('api_id');
        $id = $this->request->getVar('id');

        // Check API Key Status & Read
        //$this->check_api_key_status($api_id);

        $data['images'] = $this->contentImageGalleryModel->select('contents_images_gallery_tbl.*')->where('contents_images_gallery_tbl.content_id', $id)->get()->getResult();
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Images Gallery',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function views_plus_one()
    {
        $rules = [
            'api_id'    => 'required|integer',
            'api_key'   => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'id'        => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $id = $this->request->getVar('id');

        // Views + 1
        $db = db_connect();
        $db->query("UPDATE contents_tbl SET views = views + 1 WHERE id = '$id'");
        $db->close();

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Views Plus One',
            'id' => $id,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function downloads_plus_one()
    {
        $rules = [
            'api_id'    => 'required|integer',
            'api_key'   => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'id'        => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $id = $this->request->getVar('id');

        // Downloads + 1
        $db = db_connect();
        $db->query("UPDATE contents_tbl SET downloads = downloads + 1 WHERE id = '$id'");
        $db->close();

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Downloads Plus One',
            'id' => $id,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function dl_clicked()
    {
        $id = service('uri')->getSegment(3);
        // Check file exist
        $file = $this->contentModel->where('id', $id)->first();
        if(is_null($file))
        {
            die("404: Not Found !");

        }else{
            $url = $file->download_url;
            $this->contentModel->query("UPDATE contents_tbl SET downloads = downloads + 1 WHERE id = '$id'");
            return redirect()->to($url,null,'refresh');
        }
    }


    //===========================================================//
    public function insert_or_update_contents_downloaded()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'           => 'required|integer',
            'content_id'        => 'required|integer',
            'device_type_id'    => 'required|integer', // 1. Dashboard 2. Website 3. PWA Mobile 4. Android 5. iOS 6. Installation
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $user_id = $this->request->getVar('user_id');
        $content_id = $this->request->getVar('content_id');
        $device_type_id = $this->request->getVar('device_type_id');

        $this->contentDownloadedModel = new ContentDownloadedModel();
        $downloaded = $this->contentDownloadedModel->select('contents_downloaded_tbl.id')->where('user_id', $user_id)->where('content_id', $content_id)->where('device_type_id', $device_type_id)->first();
        if($user_id != 0)
        {
            if(is_null($downloaded))
            {
                // Insert new row
                $data = [
                    'user_id'           => $user_id,
                    'content_id'        => $content_id,
                    'device_type_id'    => $device_type_id, // 1. Dashboard 2. Website 3. PWA Mobile 4. Android 5. iOS 6. Installation
                    'ip'                => $_SERVER['REMOTE_ADDR'],
                    'agent'             => $_SERVER['HTTP_USER_AGENT'],
                ];
            }else{
                // Update old row
                $data = [
                    'id'                => $downloaded->id,
                    'user_id'           => $user_id,
                    'content_id'        => $content_id,
                    'device_type_id'    => $device_type_id, // 1. Dashboard 2. Website 3. PWA Mobile 4. Android 5. iOS 6. Installation
                    'ip'                => $_SERVER['REMOTE_ADDR'],
                    'agent'             => $_SERVER['HTTP_USER_AGENT'],
                ];
            }
            
        }else{
            // Insert new row
            $data = [
                'user_id'           => 0, // Not registered user
                'content_id'        => $content_id,
                'device_type_id'    => $device_type_id, // 1. Dashboard 2. Website 3. PWA Mobile 4. Android 5. iOS 6. Installation
                'ip'                => $_SERVER['REMOTE_ADDR'],
                'agent'             => $_SERVER['HTTP_USER_AGENT'],
            ];
        }

        $this->contentDownloadedModel->save($data);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Insert or Update contents downloaded',
            'content_id' => $content_id,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function add_review()
    {
        $this->contentReviewModel = new ContentReviewModel();

        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'	        => 'required|integer',
            'content_id'	    => 'required|integer',
            'reply_content_id'	=> 'permit_empty',
            'title'	            => 'required|min_length[2]|max_length[60]',
            'description'	    => 'required|min_length[2]|max_length[1000]',
            'rating'	        => 'required',
        ];

        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        // Valid submission
        $api_id = $this->request->getVar('api_id');
        $user_id = $this->request->getVar('user_id');
        $content_id = $this->request->getVar('content_id');

        // Check API Key Writeable
        $this->check_api_key_write($api_id);        

        // Check user sent review before
        $data['reviewBefore'] = $this->contentReviewModel->where('user_id', $user_id)->where('content_id', $content_id)->first();
        if(!is_null($data['reviewBefore']))
        {
            // The old review was exist. Unapprove and Soft Delete the old review
            $newData = [
                'id'           => $data['reviewBefore']->id,
                'approved'     => 0,
            ];
            $this->contentReviewModel->save($newData);
            $this->contentReviewModel->delete($data['reviewBefore']->id);
        }

        $newData = [
            'user_id'           => $this->request->getVar('user_id'),
            'content_id'        => $this->request->getVar('content_id'),
            'reply_content_id'  => $this->request->getVar('reply_content_id'),
            'title'             => $this->request->getVar('title'),
            'description'       => $this->request->getVar('description'),
            'rating'            => $this->request->getVar('rating'),
            'author_ip'         => $_SERVER['REMOTE_ADDR'],
            'author_agent'      => $_SERVER['HTTP_USER_AGENT'],
            'approved'          => 0,
        ];
        $this->contentReviewModel->save($newData);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Add Review',
            'data' => $newData,
        ];
        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_reviews()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'content_id'        => 'required|integer',
            'reply_content_id'  => 'required|integer',
            'limit'             => 'required|integer',
        ];
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');

        // Check API Key Status & Read
        //$this->check_api_key_status($api_id);

        $this->contentReviewModel = new ContentReviewModel();
        $data['reviews'] = $this->contentReviewModel->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, users_tbl.image AS profile_image')
            ->Where('contents_reviews_tbl.approved', 1)
            ->Where('contents_reviews_tbl.reply_content_id', $this->request->getVar('reply_content_id'))
            ->Where('contents_reviews_tbl.content_id', $this->request->getVar('content_id'))
            ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
            ->limit(intval($this->request->getVar('limit')))
            ->orderBy('contents_reviews_tbl.id', 'DESC')
            ->get()->getResult();
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);


        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Reviews',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }


    //===========================================================//
    public function send_report_abuse()
    {
        $this->contentReportModel = new ContentReportModel();

        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'	        => 'required|integer',
            'content_id'	    => 'required|integer',
            'report_abuse'	    => 'required',
        ];

        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        // Valid submission
        $api_id = $this->request->getVar('api_id');

        // Check API Key Writeable
        $this->check_api_key_write($api_id);

        $newData = [
            'user_id'           => $this->request->getVar('user_id'),
            'content_id'        => $this->request->getVar('content_id'),
            'report_abuse'      => $this->request->getVar('report_abuse'),
            'author_ip'         => $_SERVER['REMOTE_ADDR'],
            'author_agent'      => $_SERVER['HTTP_USER_AGENT'],
            'status'            => 0,
        ];
        $this->contentReportModel->save($newData);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Send Report Abuse',
            'data' => $newData,
        ];
        return $this->respondCreated($response);
    }


    //===========================================================//
    public function bookmark_status()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'	        => 'required|integer',
            'content_id'	    => 'required|integer',
        ];

        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        // Valid submission
        $api_id = $this->request->getVar('api_id');
        $user_id = $this->request->getVar('user_id');
        $file_id = $this->request->getVar('content_id');

        // Check API Key Writeable
        $this->check_api_key_write($api_id);

        // Check user exist
        $this->userModel = new UserModel();
        $user = $this->userModel->where('id', $user_id)->first();
        if(is_null($user))
        {
            echo json_encode("NoUserFound", JSON_UNESCAPED_UNICODE);
            die();
        }

        // Check file exist
        $this->contentModel = new ContentModel();
        $this->contentBookmarkModel = new ContentBookmarkModel();
        $file = $this->contentModel->where('id', $file_id)->first();
        if(is_null($file))
        {
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);
            die();

        }else{
            // Check bookmark exist
            $bookmark = $this->contentBookmarkModel->where('content_id', $file_id)->where('user_id', $user_id)->first();
            if(is_null($bookmark))
            {
                $newData = [
                    'user_id'           => $user_id,
                    'content_id'        => $file_id,
                    'is_bookmarked'     => "no",
                ];
                
            }else{
                $newData = [
                    'user_id'           => $user_id,
                    'content_id'        => $file_id,
                    'is_bookmarked'     => "yes",
                ];
            }
        }
        
        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Bookmark Status',
            'data' => $newData,
        ];
        return $this->respondCreated($response);
    }
    

    //===========================================================//
    public function add_to_bookmark()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'	        => 'required|integer',
            'content_id'	    => 'required|integer',
        ];

        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        // Valid submission
        $api_id = $this->request->getVar('api_id');
        $user_id = $this->request->getVar('user_id');
        $file_id = $this->request->getVar('content_id');

        // Check API Key Writeable
        $this->check_api_key_write($api_id);

        // Check user exist
        $this->userModel = new UserModel();
        $user = $this->userModel->where('id', $user_id)->first();
        if(is_null($user))
        {
            echo json_encode("NoUserFound", JSON_UNESCAPED_UNICODE);
            die();
        }

        // Check file exist
        $this->contentModel = new ContentModel();
        $this->contentBookmarkModel = new ContentBookmarkModel();
        $file = $this->contentModel->where('id', $file_id)->first();
        if(is_null($file))
        {
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);
            die();

        }else{
            // Check bookmark exist
            $bookmark = $this->contentBookmarkModel->where('content_id', $file_id)->where('user_id', $user_id)->first();
            if(is_null($bookmark))
            {
                $newData = [
                    'user_id'           => $user_id,
                    'content_id'        => $file_id,
                ];
                $this->contentBookmarkModel->save($newData);
                
            }else{
                echo json_encode(lang('Frontend.thisContentIsAlreadyBookmarked'), JSON_UNESCAPED_UNICODE);
                die();
            }
        }
        
        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Add To Bookmark',
            'data' => $newData,
        ];
        return $this->respondCreated($response);
    }


    //===========================================================//
    public function remove_from_bookmark()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'	        => 'required|integer',
            'content_id'	    => 'required|integer',
        ];

        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        // Valid submission
        $api_id = $this->request->getVar('api_id');
        $user_id = $this->request->getVar('user_id');
        $file_id = $this->request->getVar('content_id');

        // Check API Key Writeable
        $this->check_api_key_write($api_id);

        // Check user exist
        $this->userModel = new UserModel();
        $user = $this->userModel->where('id', $user_id)->first();
        if(is_null($user))
        {
            echo json_encode("NoUserFound", JSON_UNESCAPED_UNICODE);
            die();
        }

        // Check file exist
        $this->contentModel = new ContentModel();
        $this->contentBookmarkModel = new ContentBookmarkModel();
        $file = $this->contentModel->where('id', $file_id)->first();
        if(is_null($file))
        {
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);
            die();

        }else{
            // Check bookmark exist
            $bookmark = $this->contentBookmarkModel->where('content_id', $file_id)->where('user_id', $user_id)->first();
            if(is_null($bookmark))
            {
                echo json_encode(lang('Frontend.bookmarkIsNotExist'), JSON_UNESCAPED_UNICODE);
                die();

            }else{
                $this->contentBookmarkModel->delete($bookmark->id);
                $newData = [
                    'user_id'           => $user_id,
                    'content_id'        => $file_id,
                ];
            }
        }
        
        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Remove From Bookmark',
            'data' => $newData,
        ];
        return $this->respondCreated($response);
    }


    //===========================================================//
    public function get_bookmarks()
    {
        $rules = [
            'api_id'        => 'required|integer',
            'api_key'       => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'user_id'       => 'required|integer',
            'structure_id'  => 'required|integer',
            'type_id'       => 'permit_empty',
            'keyword'       => 'permit_empty',
            'locale'        => 'permit_empty',
            'last_id'       => 'required|integer',
            'limit'         => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $structure_id = $this->request->getVar('structure_id');
        $user_id = $this->request->getVar('user_id');
        $type_id = $this->request->getVar('type_id');
        $locale = $this->request->getVar('locale');
        $last_id = $this->request->getVar('last_id');
        $limit = intval($this->request->getVar('limit'));

        $this->contentBookmarkModel = new ContentBookmarkModel();

        if ($last_id == 0) {
            // First Time
            $data['allFiles'] = $this->contentBookmarkModel
                ->select('contents_bookmark_tbl.*, contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
                ->Where('contents_bookmark_tbl.user_id', $user_id)
                ->Where('contents_tbl.status', 1)
                ->join('contents_tbl', 'contents_tbl.id = contents_bookmark_tbl.content_id')
                ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                ->limit($limit)
                ->orderBy('contents_bookmark_tbl.id', 'DESC')
                ->get()->getResult();

        }else{
            // Load More
            $data['allFiles'] = $this->contentBookmarkModel
                ->select('contents_bookmark_tbl.*, contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title')
                ->Where('contents_bookmark_tbl.user_id', $user_id)
                ->Where('contents_tbl.status', 1)
                ->Where('contents_tbl.id <', $last_id)
                ->join('contents_tbl', 'contents_tbl.id = contents_bookmark_tbl.content_id')
                ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                ->limit($limit)
                ->orderBy('contents_bookmark_tbl.id', 'DESC')
                ->get()->getResult();
        }

        
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'All Files',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }

}
