<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersPackages') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                        <i class="fas fa-expand"></i>
                                    </button>

                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th style="width: 80px"><?= lang('Dashboard.id') ?></th>
                                        <th style="width: 120px"><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.days') ?></th>
                                        <th><?= lang('Dashboard.priceX', [$currenciesData->suffix]) ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($packages as $package)
                                    {
                                        $status = "<span class='badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($package->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.active')."</span>";
                                        ?>
                                        <tr>
                                            <td><?= $package->id; ?></td>
                                            <td><?= $package->title; ?></td>
                                            <td><?= $package->days; ?></td>
                                            <td><?= number_format($package->price, $currenciesData->decimals, '.', ','); ?></td>
                                            <td><?= $status ?></td>
                                            <td>
                                                <a href="<?= base_url('dashboard/edit-users-package/'.$package->id) ?>" class="p-1"><?= lang('Dashboard.edit') ?></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table><br>
                                <?php
                                if(empty($packages)) echo "<p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>

                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>