<?php
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/users-activity') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-hover table-striped table-sm">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.activity') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.time') ?></th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($activities as $activity)
                                    {
                                        $ip = $activity->ip;
                                        if($theRoleID == 9)
                                            $ip = 'xx.xx.xx.xx';
                                        ?>
                                        <tr class="i-text-small">
                                            <td>
                                                <a href="<?= $activity->user_id != 0 ? base_url('dashboard/user-profile/'.$activity->user_id) : '#' ?>">
                                                    <?= $activity->first_name . " " . $activity->last_name ?>
                                                </a>
                                            </td>
                                            <td><?= $activity->title; ?></td>
                                            <td><?= $activity->body; ?></td>
                                            <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $ip ?>" title="<?= $activity->agent ?>"><?= $ip ?></a></td>
                                            <td>
                                                <?php
                                                if($settingsData->calendar_type == "jDate")
                                                {
                                                    echo $time = $jdf->jdate('Y/m/d G:i', $activity->time, '', $settingsData->timezone);
                                                }else{
                                                    echo $time = Time::createFromTimestamp($activity->time, $settingsData->timezone, 'en_US');
                                                }
                                                ?>
                                            </td>
                                            <td><?= timespan($activity->time, time(), 2)." ".lang('Date.ago'); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <br>
                                <div class="px-2"><?= $pager->Links() ?></div>
                                <?php
                                if(empty($activities)) echo "<p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br><br></p>";
                                ?>

                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>