<?php
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
$session = session();
$encrypter = \Config\Services::encrypter();
$api_key = random_string('alnum', 32);
$api_id = $api_read = $api_write = $api_status = "";
if(isset($api->api_key))
{
   $api_id = $api->id;
   $api_key = $api->api_key;
   $api_key = $encrypter->decrypt(base64_decode($api_key));
   $api_read = $api->read;
   $api_write = $api->write;
   $api_status = $api->status;
}
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<?php
$active_tab = "";
if(isset($_GET['active_tab']))
    $active_tab = $_GET['active_tab'];
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-3">

                        <!-- Profile Image -->
                        <div class="card card-primary card-outline">
                            <div class="card-body box-profile">
                                <div class="text-center">
                                    <img class="profile-user-img img-fluid img-circle"
                                         src="<?= base_url('backend/assets/uploads/users/profile/thumb/'.$user->image) ?>"
                                         alt="User profile picture">
                                </div>

                                <h3 class="profile-username text-center"><?= $user->first_name." ".$user->last_name ?></h3>

                                <p class="text-muted text-center"><?= $user->email ?></p>

                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b><?= $walletData->title ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= number_format($walletData->credit, $currenciesData->decimals, '.', ','); ?> <?= $currenciesData->suffix ?></span>
                                    </li>

                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.userRole') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $user->role_title ?></span>
                                    </li>
                                    <?php
                                    if($user->role_id == 11 && $user->vip_role_expiry_at != null)
                                    {
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.remainingDaysUntilTheVIPUserExpires') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $daysRemaining ?> <?= lang('Dashboard.days') ?></span>
                                    </li>
                                    <?php
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.deviceType') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $user->device_type_title; ?></span>
                                    </li>
                                    <?php
                                    $last_login = lang('Dashboard.notYetEntered');
                                    if(isset($user->last_login))
                                    {
                                        if($settingsData->calendar_type == "jDate")
                                        {
                                            $last_login = $jdf->jdate('Y/m/d G:i', $user->last_login, '', $settingsData->timezone);
                                        }else{
                                            $last_login = Time::createFromTimestamp($user->last_login, $settingsData->timezone, 'en_US');
                                        }
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.lastLogin') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $last_login; ?></span>
                                    </li>
                                    <?php
                                    if($settingsData->calendar_type == "jDate")
                                    {
                                        $member_since = $jdf->jdate('Y/m/d G:i', $user->created_at, '', $settingsData->timezone);
                                    }else{
                                        $member_since = Time::createFromTimestamp($user->created_at, $settingsData->timezone, 'en_US');
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.memberSince') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $member_since; ?></span>
                                    </li>
                                </ul>

                                <?php
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <a href="<?= base_url('dashboard/deactivate-profile') ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureToDeactivateYourAccount') ?>');" class="btn btn-outline-danger btn-block"><b><?= lang('Dashboard.deactivatedAccount') ?></b></a>
                                    <?php
                                }else{
                                    ?>
                                    <button disabled href="#" onclick="return alert('<?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?>');" class="btn btn-outline-danger btn-block"><b><?= lang('Dashboard.deactivatedAccount') ?></b></button>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                    <div class="col-md-9">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <div class="card">
                            <div class="card-header p-2">
                                <ul class="nav nav-pills">
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "") echo "active"; ?>" href="#activity" data-toggle="tab"><?= lang('Dashboard.activity') ?></a></li>
                                    <?php
                                    if($user->role_id >= 10) {
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "user_role") echo "active"; ?>" href="#user_role" data-toggle="tab"><?= lang('Dashboard.userRole') ?></a></li>
                                    <?php
                                    }
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "settings") echo "active"; ?>" href="#settings" data-toggle="tab"><?= lang('Dashboard.settings') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "change_password") echo "active"; ?>" href="#change_password" data-toggle="tab"><?= lang('Dashboard.changePassword') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "change_image") echo "active"; ?>" href="#change_image" data-toggle="tab"><?= lang('Dashboard.changeImage') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "downloaded") echo "active"; ?>" href="#downloaded" data-toggle="tab"><?= lang('Dashboard.downloaded') ?></a></li>
                                    <?php
                                    if($user->api_key_access != 0)
                                    {
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "api_key") echo "active"; ?>" href="#api_key" data-toggle="tab"><?= lang('Dashboard.apiKey') ?></a></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </div><!-- /.card-header -->
                            <div class="card-body">
                                <div class="tab-content">
                                    <div class="<?php if($active_tab == "") echo "active"; ?> tab-pane" id="activity">

                                        <!-- The timeline -->
                                        <div class="timeline timeline-inverse">
                                            <!-- timeline time label -->
                                            <div class="time-label">
                                        <span class="bg-warning">
                                          <?php
                                          if ($settingsData->calendar_type == "jDate") {
                                              echo $today = $jdf->jdate('Y/m/d', now(), '', $settingsData->timezone);
                                          } else {
                                              $today = Time::createFromTimestamp(now(), $settingsData->timezone, 'en_US');
                                              echo $today->getYear()."/".$today->getMonth()."/".$today->getDay();
                                          }
                                          ?>
                                        </span>
                                            </div>
                                            <!-- /.timeline-label -->

                                            <!-- timeline item -->
                                            <?php
                                            foreach ($activities as $activity)
                                            {
                                            ?>
                                                <div>
                                                    <i class="<?= $activity->icon ?> <?= $activity->background ?>"></i>
                                                    <div class="timeline-item">
                                                        <span class="time"><i class="far fa-clock"></i> <?= timespan($activity->time, now(), 2)." ".lang('Date.ago'); //date('Y/m/d H:i:s', $activity->time) ?></span>
                                                        <h3 class="timeline-header"><?= $activity->title ?></h3>
                                                        <div class="timeline-body"><?= $activity->body ?></div>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                            <!-- END timeline item -->

                                            <div>
                                                <i class="far fa-clock bg-gray"></i>
                                            </div>
                                        </div>
                                        <div class="px-2"><?= $activities_pager->Links() ?></div>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "user_role") echo "active"; ?> tab-pane" id="user_role">
                                        <p><?= lang('Dashboard.upgradeUserRoleDescription') ?></p>

                                        <form class="form-horizontal" data-form-type="upgrade_user_role" data-action="<?= base_url('dashboard/perform-upgrade-user-role') ?>">
                                            <?= csrf_field() ?>
                                            <div class="row">

                                            <?php
                                            foreach ($vipPackages as $vipPackage) {
                                            ?>
                                                <div class="col-12 col-sm-3" style="cursor: pointer" onclick="document.getElementById('<?= $vipPackage->id ?>').checked = true;">
                                                    <div class="info-box bg-light">
                                                        <div class="info-box-content">
                                                            <span class="info-box-text text-center text-muted"><i class="fas fa-user-check"></i></span>
                                                            <span class="info-box-text text-center text-muted"><?= $vipPackage->title ?></span>
                                                            <span class="info-box-number text-center text-muted mb-0"><?= number_format($vipPackage->price, $currenciesData->decimals, '.', ','); ?> <span class="font-width-normal small"><?= $currenciesData->suffix ?></span></span>
                                                            <input class="mt-1" type="radio" id="<?= $vipPackage->id ?>" name="vip_package" value="<?= $vipPackage->id ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                            </div>
                                            <input type="hidden" name="wallet_id" value="<?= $walletData->id ?>" readonly>
                                        
                                            <div class="form-group row text-center mt-4">
                                                <div class="offset-sm-0 col-sm-12">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="submitButton" class="submitButton btn btn-success" value="<?= lang('Dashboard.upgradeUserRole') ?>"><b><?= lang('Dashboard.upgradeUserRole') ?></b></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="submitButton btn btn-danger"><?= lang('Dashboard.upgradeUserRole') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "settings") echo "active"; ?> tab-pane" id="settings">
                                        <form class="form-horizontal" action="<?= base_url('dashboard/perform-update-profile') ?>" method="post" onsubmit="buttonLoading5()">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="first_name" class="col-sm-2 col-form-label"><?= lang('Dashboard.firstName') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?= lang('Dashboard.firstName') ?>" value="<?= $user->first_name ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="last_name" class="col-sm-2 col-form-label"><?= lang('Dashboard.lastName') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?= lang('Dashboard.lastName') ?>" value="<?= $user->last_name ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="gender" class="col-sm-2 col-form-label"><?= lang('Dashboard.gender') ?> *</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="gender" id="gender" required>
                                                        <?php
                                                        $selected1 = $selected2 = "";
                                                        if($user->gender == 1) $selected1 = "selected";
                                                        if($user->gender == 2) $selected2 = "selected";
                                                        ?>
                                                        <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                        <option <?= $selected1 ?> value="1"><?= lang('Dashboard.male') ?></option>
                                                        <option <?= $selected2 ?> value="2"><?= lang('Dashboard.female') ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="email" class="col-sm-2 col-form-label"><?= lang('Dashboard.email') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="email" class="form-control" name="email" id="email" placeholder="<?= lang('Dashboard.email') ?>" value="<?= $user->email ?>" required disabled>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="phone" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="phone" id="phone" placeholder="<?= lang('Dashboard.phone') ?>" value="<?= $user->phone ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="mobile" class="col-sm-2 col-form-label"><?= lang('Dashboard.mobile') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="mobile" id="mobile" placeholder="<?= lang('Dashboard.mobile') ?>" value="<?= $user->mobile ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="address" class="col-sm-2 col-form-label"><?= lang('Dashboard.address') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="address" id="address" placeholder="<?= lang('Dashboard.address') ?>" value="<?= $user->address ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="postcode" class="col-sm-2 col-form-label"><?= lang('Dashboard.postcode') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="postcode" id="postcode" placeholder="<?= lang('Dashboard.postcode') ?>" value="<?= $user->postcode ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="dark_mode" class="col-sm-2 col-form-label"><?= lang('Dashboard.showMode') ?></label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="dark_mode" id="dark_mode" required>
                                                        <?php
                                                        $selected1 = $selected2 = "";
                                                        if($user->dark_mode == 0) $selected1 = "selected";
                                                        if($user->dark_mode == 1) $selected2 = "selected";
                                                        ?>
                                                        <option <?= $selected1 ?> value="0"><?= lang('Dashboard.lightMode') ?></option>
                                                        <option <?= $selected2 ?> value="1"><?= lang('Dashboard.darkMode') ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="user_note" class="col-sm-2 col-form-label"><?= lang('Dashboard.note') ?></label>
                                                <div class="col-sm-10">
                                                    <textarea class="form-control" rows="3" name="user_note" id="user_note" placeholder="<?= lang('Dashboard.note') ?>"><?= $user->user_note ?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input checked name="terms" type="checkbox"> <?= lang('Dashboard.IAgreeToTheTermsOfService', [$settingsData->terms_url]) ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="submitButton5" class="btn btn-outline-primary" value="<?= lang('Dashboard.edit') ?>"><?= lang('Dashboard.edit') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.edit') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "change_password") echo "active"; ?> tab-pane" id="change_password">
                                        <form class="form-horizontal" action="<?= base_url('dashboard/perform-change-password') ?>" method="post" onsubmit="buttonLoading2()">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="current_password" class="col-sm-2 col-form-label"><?= lang('Dashboard.currentPassword') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control" name="current_password" id="current_password" placeholder="<?= lang('Dashboard.currentPassword') ?>" value="" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="password" class="col-sm-2 col-form-label"><?= lang('Dashboard.newPassword') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?= lang('Dashboard.newPassword') ?>" value="" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="password_confirm" class="col-sm-2 col-form-label"><?= lang('Dashboard.retypePassword') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control" name="password_confirm" id="password_confirm" placeholder="<?= lang('Dashboard.retypePassword') ?>" value="" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="submitButton2" class="btn btn-outline-primary" value="<?= lang('Dashboard.changePassword') ?>"><?= lang('Dashboard.changePassword') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.changePassword') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "change_image") echo "active"; ?> tab-pane" id="change_image">

                                        <form method="POST" enctype="multipart/form-data" class="form-horizontal" action="<?= base_url('dashboard/perform-change-image'); ?>" accept-charset="UTF-8" onsubmit="buttonLoading3()">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="image" class="col-sm-2 col-form-label"><?= lang('Dashboard.newImage') ?> *</label>
                                                <div class="col-sm-10">
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" name="image" required>
                                                            <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                        </div>
                                                    </div>
                                                    <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                                    <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 300, 300 ]) ?></small><br>
                                                    <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 2048 ]) ?></small>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <input type="hidden" readonly name="old_image" value="<?= $user->image; ?>">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                    ?>
                                                        <button id="submitButton3" type="submit" class="btn btn-outline-primary" value="<?= lang('Dashboard.changeImage') ?>"><?= lang('Dashboard.changeImage') ?></button>
                                                    <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.changeImage') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "downloaded") echo "active"; ?> tab-pane" id="downloaded">
                                        <div class="card-body table-responsive p-0">
                                            <table class="table table-hover text-nowrap">
                                                <thead>
                                                <tr>
                                                    <th><?= lang('Dashboard.file') ?></th>
                                                    <th><?= lang('Dashboard.device') ?></th>
                                                    <th><?= lang('Dashboard.ip') ?></th>
                                                    <th><?= lang('Dashboard.firstDownload') ?></th>
                                                    <th><?= lang('Dashboard.lastDownload') ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                foreach ($downloaded as $dl)
                                                {
                                                    if($settingsData->calendar_type == "jDate")
                                                    {
                                                        $created_at = $jdf->jdate('Y/m/d G:i', $dl->created_at, '', $settingsData->timezone);
                                                        $updated_at = $jdf->jdate('Y/m/d G:i', $dl->updated_at, '', $settingsData->timezone);
                                                    }else{
                                                        $created_at = Time::createFromTimestamp($dl->created_at, $settingsData->timezone, 'en_US');
                                                        $updated_at = Time::createFromTimestamp($dl->updated_at, $settingsData->timezone, 'en_US');
                                                    }
                                                    $dl_ip = $dl->ip;
                                                    if($theRoleID == 9)
                                                        $dl_ip = 'xx.xx.xx.xx';
                                                    ?>
                                                    <tr>
                                                        <td><a target="_blank" title="<?= $dl->file_title ?>" href="<?= base_url("file-details/$dl->content_id/$dl->file_title_slug?id=$dl->content_id") ?>"</a><?= $dl->file_title ?></td>
                                                        <td><?= $dl->device_type_title; ?></td>
                                                        <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $dl_ip ?>" title="<?= $dl->agent ?>"><?= $dl_ip ?></a></td>
                                                        <td><?= $created_at; ?></td>
                                                        <td><?= $updated_at; ?></td>
                                                    </tr>
                                                    <?php
                                                }
                                                ?>
                                                </tbody>
                                            </table>
                                            <?php
                                            if(empty($downloaded)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                            ?>
                                            <br>
                                            <div class="px-0 text-center">
                                                <?php
                                                if(!empty($downloaded)) { ?>
                                                    <a type="button" class="btn btn-sm btn-outline-success" href="<?= base_url("dashboard/downloaded-files?keyword=$user->email") ?>" ><?= lang('Dashboard.seeMore') ?></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                    <!-- /.tab-pane -->

                                    <?php
                                    if($user->api_key_access != 0)
                                    {
                                    ?>
                                    <div class="<?php if($active_tab == "api_key") echo "active"; ?> tab-pane" id="api_key">

                                        <form method="POST" enctype="multipart/form-data" class="form-horizontal" action="<?= base_url('dashboard/perform-update-api-key'); ?>" accept-charset="UTF-8" onsubmit="buttonLoading4()">
                                            <?= csrf_field() ?>

                                            <div class="form-group row">
                                                <label for="id" class="col-sm-2 col-form-label"><?= lang('Dashboard.apiId') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="id" id="id" disabled readonly placeholder="<?= lang('Dashboard.apiId') ?>" value="<?= $api_id ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="api_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.apiKey') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="api_key" id="api_key" placeholder="<?= lang('Dashboard.apiKey') ?>" value="<?= $api_key ?>" required>
                                                    <small class="text-info"><?= lang('Dashboard.minimumOf32CharactersAndMaximumOf64Characters') ?></small>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="current_password" class="col-sm-2 col-form-label"><?= lang('Dashboard.password') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control" name="current_password" id="current_password" placeholder="<?= lang('Dashboard.adminDashboardPassword') ?>" value="" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $checked_read = $checked_write = $checked_status = "";
                                                            if($api_read == 1) $checked_read = "checked";
                                                            if($api_write == 1) $checked_write = "checked";
                                                            if($api_status == 1) $checked_status = "checked";
                                                            ?>
                                                            <input <?= $checked_read ?> name="read" type="checkbox"> <?= lang('Dashboard.readAbility') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input <?= $checked_write ?> name="write" type="checkbox"> <?= lang('Dashboard.writeAbility') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input <?= $checked_status ?> name="status" type="checkbox"> <?= lang('Dashboard.enableApiKey') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19 AND $user->api_key_access != 0)
                                                    {
                                                        ?>
                                                        <input type="hidden" readonly class="form-control" name="id" id="id" value="<?= $api_id ?>">
                                                        <button id="submitButton4" type="submit" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                    <!-- /.tab-pane -->
                                    <?php
                                    }
                                    ?>
                                </div>
                                <!-- /.tab-content -->
                            </div><!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>