<?php
$this->session = session();
$locale = $this->session->lang;
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';
$wallet_id = isset($_GET['wallet_id']) ? $_GET['wallet_id'] : '';
$order_id = isset($_GET['order_id']) ? $_GET['order_id'] : '';
$amount = isset($_GET['amount']) ? $_GET['amount'] : '';
$description = isset($_GET['description']) ? $_GET['description'] : '';
$transaction_date = isset($_GET['transaction_date']) ? $_GET['transaction_date'] : time();

if($settingsData->calendar_type == "jDate")
{
    $transaction_date = $jdf->jdate('Y/m/d', $transaction_date, '', $settingsData->timezone);
}else{
    $transaction_date = Time::createFromTimestamp($transaction_date, $settingsData->timezone, 'en_US');
    $transaction_date = $transaction_date->toDateString();
}
?>

<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.wallet') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" data-form-type="offline_payment" data-action="<?= base_url('dashboard/perform-offline-payment') ?>" enctype="multipart/form-data">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="amount" class="col-sm-3 col-form-label"><?= lang('Dashboard.amount') ?> *</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="text" name="amount" id="amount" dir="ltr" class="form-control" value="<?= $amount ?>" required>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"><?= $currenciesData->suffix ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="transaction_tracking" class="col-sm-3 col-form-label"><?= lang('Dashboard.transactionTracking') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="transaction_tracking" id="transaction_tracking" class="form-control" required>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label for="amount" class="col-sm-3 col-form-label"><?= lang('Dashboard.date') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="transaction_date" id="transaction_date" class="form-control" value="<?= $transaction_date ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="description" class="col-sm-3 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control" name="description" rows="4" required><?= $description ?></textarea>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?> *</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image" required>
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.selectImageOfBankReceipt') ?>...</label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                        </div>
                                    </div>

                                    <input type="hidden" name="wallet_id" id="wallet_id" value="<?= $walletData->id ?>" readonly required>
                                    <input type="hidden" name="currency_decimals" id="currency_decimals" value="<?= $currenciesData->decimals ?>" readonly required>
                                    <input type="hidden" name="currency_suffix" id="currency_suffix" value="<?= $currenciesData->suffix ?>" readonly required>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                ?>
                                    <button type="submit" id="submitButton" class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.bankReceiptSubmission') ?>"><?= lang('Dashboard.bankReceiptSubmission') ?>
                                    </button>
                                <?php
                                }else{
                                ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.bankReceiptSubmission') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-7">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.bankAccount') ?></h3>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-warning">
                                    <strong><?= lang('Dashboard.tip') ?> !<br></strong> <?= lang('Dashboard.bankAccountDesc') ?></a>
                                </div>
                                <p><?= $settingsData->bank_account ?></p>
                            </div>
                            <!-- /.card-body -->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
  
<?= $this->endSection() ?>