<?php

use App\Models\Backend\CategoryModel;
$categoryModel = new CategoryModel();

?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.testimonials') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th class="text-nowrap"><?= lang('Dashboard.fullName') ?></th>
                                        <th><?= lang('Dashboard.testimonials') ?></th>
                                        <th><?= lang('Dashboard.stars') ?></th>
                                        <th><?= lang('Dashboard.image') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($testimonials as $testimonial)
                                    {
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $testimonial->full_name ?></td>
                                            <td class="align-middle"><?= $testimonial->testimonials ?></td>
                                            <td class="align-middle"><?= $testimonial->stars ?> <i class="fas fa-star fa-sm text-yellow"></i></td>
                                            <td class="align-middle"><img width="64px" height="auto" src="<?= base_url("backend/assets/uploads/admins/testimonials/$testimonial->image") ?>" class="img-circle" alt="<?= $testimonial->full_name ?>"></td>
                                            <td class="align-middle">
                                                <div class="dropdown">
                                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown">
                                                        <?= lang('Dashboard.action') ?>
                                                    </button>
                                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>">
                                                        <a class="dropdown-item" title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/edit-testimonials/'.$testimonial->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i> <?= lang('Dashboard.edit') ?></a>
                                                        <div class="dropdown-divider"></div> 
                                                        <a class="dropdown-item text-danger" title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-testimonials/'.$testimonial->id); ?>" onclick="confirmAction(event, '<?= lang('Dashboard.delete') ?>', '<?= lang('Dashboard.areYouSureYouWantToDeleteX', [$testimonial->full_name]) ?>', 'warning', this);"><i class="fas fa-trash-alt"></i> <?= lang('Dashboard.delete') ?></a>
                                                    </div>
                                                </div> 
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($testimonials)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
    // Pass language variables to confirmAction function.
    var lang_yes = "<?= lang('Dashboard.yes') ?>";
    var lang_no = "<?= lang('Dashboard.no') ?>";
</script>
<?= $this->endSection() ?>