<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.testimonials') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/testimonials') ?>" class="dropdown-item"><?= lang('Dashboard.usersTestimonials') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" data-form-type="edit_testimonials" data-action="<?= base_url('dashboard/perform-edit-testimonials') ?>" enctype="multipart/form-data">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="full_name" class="col-sm-3 col-form-label"><?= lang('Dashboard.fullName') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="full_name" id="full_name" placeholder="<?= lang('Dashboard.fullName') ?>" value="<?= $testimonials->full_name ?>" required>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="testimonials" class="col-sm-3 col-form-label"><?= lang('Dashboard.testimonials') ?> *</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control" name="testimonials" rows="4" placeholder="<?= lang('Dashboard.testimonials') ?>" required><?= $testimonials->testimonials ?></textarea>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="stars" class="col-sm-3 col-form-label"><?= lang('Dashboard.stars') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="stars" id="stars" required>
                                                <option value="1" <?= ($testimonials->stars == 1) ? 'selected' : '' ?>>1</option>
                                                <option value="2" <?= ($testimonials->stars == 2) ? 'selected' : '' ?>>2</option>
                                                <option value="3" <?= ($testimonials->stars == 3) ? 'selected' : '' ?>>3</option>
                                                <option value="4" <?= ($testimonials->stars == 4) ? 'selected' : '' ?>>4</option>
                                                <option value="5" <?= ($testimonials->stars == 5) ? 'selected' : '' ?>>5</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?></label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 256, 256 ]) ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]) ?></small>
                                        </div>
                                    </div>

                                    <input type="hidden" readonly name="id" value="<?= $testimonials->id ?>" required>
                                    <input type="hidden" readonly name="old_image" value="<?= $testimonials->image ?>" required>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.editTestimonials') ?>"><?= lang('Dashboard.editTestimonials') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.editTestimonials') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>