<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.page') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-12">
                        <!-- Default box -->
                        <div class="card" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                        <i class="fas fa-expand"></i>
                                    </button>

                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <h5 style="text-align: center"><strong>Your Purchase Code: <?= getenv('LICENSE_KEY') ?></strong></h5>
                                <br><hr>

                                <h4 id="item-description__you_can_do">
                                    <strong style="color:green">You Can Do</strong></h4>
                                <ul>
                                    <li>Use on (1) domain only.</li>
                                    <li>Modify or edit codes as you want.</li>
                                    <li>Translate language as you want.</li>
                                </ul>
                                <br>

                                <h4 id="item-description__you_can_not_do">
                                    <strong style="color:red">You Can Not Do</strong></h4>
                                <ul>
                                    <li>Resell, distribute, give away or trade by any means to any third party or individual without permission.</li>
                                    <li>Include this product into other products sold on Envato market and its affiliate websites or other markets.</li>
                                    <li>Use on more than (1) domain.</li>
                                </ul>
                                <br>

                                <h4 id="item-license">
                                    <strong>Regular or Extended License</strong></h4>

                                <p>By following License Type, you must use Extended License if:
									<ul>
										<li>Publish your app as a <strong>PAID</strong> app.</li>
										<li>Your App is <strong>In-App Purchase</strong> (mean your user able to buy some feature).</li>
										<li>You want to receive payment gateways.</li>
										<li>You want to receive the support ticket module.</li>
									</ul>
									Both Regular & Extended license are allowed to be installed on <strong>One Domain</strong>. The main difference between these licenses is that under the Regular License, your end product (incorporating the item you've purchased) is distributed free of charge, whereas under the Extended License your end product may be sold or otherwise limited to paying customers.<br>
									Also, in Extended license, you will receive more facilities, including online and offline <strong>Payment Gateways</strong>, digital currency payment gateways, and purchasing a VIP subscription to receive files for VIP users and the user <strong>Support Ticket</strong> module.
								</p>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>