<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.page') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-12">
                        <!-- Default box -->
                        <div class="card" id="myCard">
                            <div class="card-body">
                                <h5 class="text-center"><span class="h3 text-success">●</span> <?= lang('Dashboard.databaseIsRunning') ?><br><br></h5>

                                <p style="direction: ltr; text-align: left">
                                    <?php
                                    foreach ($tables as $table) {
                                        echo $table;
                                        echo " <span class='text-danger'><strong>―</strong></span> ";
                                    }
                                    ?>
                                </p>
                            </div>

                            <div class="card-footer">
                                <form method="POST" action="<?= base_url('dashboard/perform-optimise-tables'); ?>" accept-charset="UTF-8" onsubmit="buttonLoading()">
                                    <?= csrf_field() ?>

                                    <?php
                                    $session = session();
                                    $role_id = $session->role_id;
                                    if($role_id != 9 AND $role_id != 19)
                                    {
                                        ?>
                                        <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.optimiseTables') ?>"><?= lang('Dashboard.optimiseTables') ?></button>
                                        <?php
                                    }else{
                                        ?>
                                        <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.optimiseTables') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                        <?php
                                    }
                                    ?>
                                </form>
                            </div>

                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>