<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.versionControl') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></a></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/version-control') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.date') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.versionCode') ?></th>
                                        <th><?= lang('Dashboard.versionName') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($versions as $version)
                                    {
                                        $status = "<span class='badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($version->status == 0) $status = "<span class='center badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($version->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.active')."</span>";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $version->release_date ?></td>
                                            <td class="align-middle"><?= $version->title ?></td>
                                            <td class="align-middle"><?= $version->version_code ?></td>
                                            <td class="align-middle"><?= $version->version_name ?></td>
                                            <td class="align-middle"><?= $status ?></td>
                                            <td class="align-middle" style="width: 118px;">
                                                <a target="_blank" title="<?= lang('Dashboard.show') ?>" href="<?= base_url("version/$version->id?version=$version->version_name") ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>
                                                <a title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/edit-version/'.$version->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>
                                                <a title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-version/'.$version->id); ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" class="text-danger p-1">&nbsp;<i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($versions)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <a href="<?= base_url('dashboard/add-version') ?>" class="btn btn-sm btn-info float-right"><?= lang('Dashboard.addVersion') ?></a>
                            </div>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>