<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-home-configuration') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">

                                    <div class="form-group row">
                                        <label for="home_page" class="col-sm-3 col-form-label"><?= lang('Dashboard.homePage') ?> *</label>
                                        <div class="col-sm-9">
                                            <?php
                                            $selected1 = $selected2 = "";
                                            if($homeConfiguration->home_page == 1) $selected1 = "selected";
                                            if($homeConfiguration->home_page == 2) $selected2 = "selected";
                                            ?>
                                            <select class="form-control" name="home_page" id="home_page" required>
                                                <option <?= $selected1 ?> value="1"><?= lang('Dashboard.showHomePage') ?></option>
                                                <option <?= $selected2 ?> value="2"><?= lang('Dashboard.showBlogPosts') ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div id="hidden_div">
                                        <div class="form-group row">
                                            <label for="show_special_apps" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_special_apps == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_special_apps" id="show_special_apps" <?= $checked ?>>
                                                    <label for="show_special_apps" class="custom-control-label"><?= lang('Dashboard.showSpecialApps') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_special_games" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_special_games == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_special_games" id="show_special_games" <?= $checked ?>>
                                                    <label for="show_special_games" class="custom-control-label"><?= lang('Dashboard.showSpecialGames') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_featured_apps" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_featured_apps == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_featured_apps" id="show_featured_apps" <?= $checked ?>>
                                                    <label for="show_featured_apps" class="custom-control-label"><?= lang('Dashboard.showFeaturedApps') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_featured_games" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_featured_games == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_featured_games" id="show_featured_games" <?= $checked ?>>
                                                    <label for="show_featured_games" class="custom-control-label"><?= lang('Dashboard.showFeaturedGames') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_latest_apps" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_latest_apps == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_latest_apps" id="show_latest_apps" <?= $checked ?>>
                                                    <label for="show_latest_apps" class="custom-control-label"><?= lang('Dashboard.showLatestApps') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_latest_games" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_latest_games == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_latest_games" id="show_latest_games" <?= $checked ?>>
                                                    <label for="show_latest_games" class="custom-control-label"><?= lang('Dashboard.showLatestGames') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_newsletter" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_newsletter == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_newsletter" id="show_newsletter" <?= $checked ?>>
                                                    <label for="show_newsletter" class="custom-control-label"><?= lang('Dashboard.showNewsletter') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_statistics" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_statistics == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_statistics" id="show_statistics" <?= $checked ?>>
                                                    <label for="show_statistics" class="custom-control-label"><?= lang('Dashboard.showStatistics') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_testimonials" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_testimonials == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_testimonials" id="show_testimonials" <?= $checked ?>>
                                                    <label for="show_testimonials" class="custom-control-label"><?= lang('Dashboard.showTestimonials') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="show_recent_posts" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_recent_posts == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_recent_posts" id="show_recent_posts" <?= $checked ?>>
                                                    <label for="show_recent_posts" class="custom-control-label"><?= lang('Dashboard.showRecentPosts') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row d-none">
                                            <label for="show_random_posts" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_random_posts == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" disabled name="show_random_posts" id="show_random_posts" <?= $checked ?>>
                                                    <label for="show_random_posts" class="custom-control-label"><?= lang('Dashboard.showRandomPosts') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row d-none">
                                            <label for="show_special_posts" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_special_posts == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_special_posts" id="show_special_posts" <?= $checked ?>>
                                                    <label for="show_special_posts" class="custom-control-label"><?= lang('Dashboard.showSpecialPosts') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row d-none">
                                            <label for="show_featured_posts" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_featured_posts == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_featured_posts" id="show_featured_posts" <?= $checked ?>>
                                                    <label for="show_featured_posts" class="custom-control-label"><?= lang('Dashboard.showFeaturedPosts') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row d-none">
                                            <label for="show_pricing_plan" class="col-sm-3 col-form-label"></label>
                                            <div class="col-sm-9">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($homeConfiguration->show_pricing_plan == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_pricing_plan" id="show_pricing_plan" <?= $checked ?>>
                                                    <label for="show_pricing_plan" class="custom-control-label"><?= lang('Dashboard.showPricingPlan') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row d-none">
                                        <label for="show_faq" class="col-sm-3 col-form-label"></label>
                                        <div class="col-sm-9">
                                            <div class="custom-control custom-checkbox">
                                                <?php
                                                $checked = "";
                                                if($homeConfiguration->show_faq == 1) $checked = "checked";
                                                ?>
                                                <input type="checkbox" class="custom-control-input" disabled name="show_faq" id="show_faq" <?= $checked ?>>
                                                <label for="show_faq" class="custom-control-label"><?= lang('Dashboard.showFaq') ?></label>
                                            </div>
                                        </div>
                                    </div>
                                    </div>

                                    <?php
                                    // If home_page = 2 -> 'Blog Posts' then hidden div
                                    if($homeConfiguration->home_page == 2)
                                    {
                                    ?>
                                    <script>
                                        window.onload = function() {
                                            document.getElementById('hidden_div').style.display = 'none';
                                        };
                                    </script>
                                    <?php
                                    }
                                    ?>

                                    <script>
                                        document.getElementById('home_page').addEventListener('change', function () {
                                            var style = this.value == 1 ? 'block' : 'none';
                                            document.getElementById('hidden_div').style.display = style;
                                        });
                                    </script>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="id" readonly required value="<?= service('uri')->getSegment(3) ?>">
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>