<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" data-form-type="edit_currency_unit" data-action="<?= base_url('dashboard/perform-edit-currency-unit') ?>">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    
                                    <div class="form-group row">
                                        <label for="currency_code" class="col-sm-3 col-form-label"><?= lang('Dashboard.currencyCode') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="currency_code" value="<?= $currencyUnit->currency_code ?>" dir="ltr" placeholder="USD" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="locale" class="col-sm-3 col-form-label"><?= lang('Dashboard.locale') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="locale" value="<?= $currencyUnit->locale ?>" dir="ltr" placeholder="en" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="decimals" class="col-sm-3 col-form-label"><?= lang('Dashboard.decimals') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="decimals" value="<?= $currencyUnit->decimals ?>" dir="ltr" placeholder="2" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="prefix" class="col-sm-3 col-form-label"><?= lang('Dashboard.prefix') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="prefix" value="<?= $currencyUnit->prefix ?>" dir="ltr" placeholder="$">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="suffix" class="col-sm-3 col-form-label"><?= lang('Dashboard.suffix') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="suffix" value="<?= $currencyUnit->suffix ?>" dir="ltr" placeholder="US Dollar">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="rate" class="col-sm-3 col-form-label"><?= lang('Dashboard.rate') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="rate" value="<?= $currencyUnit->rate ?>" dir="ltr" placeholder="Ex: price * rate (10 * 600000)" required>
                                        </div>
                                    </div>
                                    
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>