<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('tags-input-header') ?>
<!-- Tags Input: https://github.com/erwinheldy/tagin -->
    <link rel="stylesheet" href="<?= base_url('backend/assets/dist/css/tagin/tagin.min.css'); ?>">
<?= $this->endSection() ?>

<?= $this->section('tags-input-footer') ?>
    <!-- Tags Input -->
    <script src="<?= base_url('backend/assets/dist/js/tagin/tagin.min.js'); ?>"></script>
    <script>
        document.querySelectorAll('.tagin:not([id])').forEach((el) => {
            if (el instanceof HTMLInputElement) {
                const tagin = new Tagin(el)
            }
        })

        const testAdd = new Tagin(document.getElementById('test-add'))
        document.getElementById('add1').addEventListener('click', function () {
            testAdd.addTag('yellow')
            this.remove()
        })
        document.getElementById('add2').addEventListener('click', function () {
            testAdd.addTag(['cyan', 'black'])
            this.remove()
        })

        const testValue = new Tagin(document.getElementById('test-value'))
        document.getElementById('get').addEventListener('click', function () {
            const value = testValue.getTag()
            const values = JSON.stringify(testValue.getTags())
            document.getElementById('value-container').innerHTML = `${value}<br>${values}`
        })


        // Example starter JavaScript for disabling form submissions if there are invalid fields
        void (function() {
            document.querySelectorAll('.needs-validation').forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }

                    form.classList.add('was-validated')
                })
            })
        })()
    </script>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.dynamicPages') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-page') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                    <?= csrf_field() ?>
                <div class="row">
                    <div class="col-md-9">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/pages-list') ?>" class="dropdown-item"><?= lang('Dashboard.pagesList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>

                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.title') ?> *</label>
                                                <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= $page->title ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.titleSlug') ?> *</label>
                                                <input type="text" class="form-control" name="title_slug" id="title_slug" value="<?= $page->title_slug ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.pageContents') ?> *</label>
                                                <br>
                                                <textarea name="page_contents" id="summernote"><?= $page->page_contents ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <br>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="description" class="col-sm-2 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="description" id="description" placeholder="<?= lang('Dashboard.description') ?>" value="<?= $page->description ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaDescriptionText') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="keywords" class="col-sm-2 col-form-label"><?= lang('Dashboard.keywords') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="keywords" data-tagin-enter placeholder="<?= lang('Dashboard.keywords') ?>" data-tagin-placeholder="<?= lang('Dashboard.keywords').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= $page->keywords ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaKeywords') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="tags" class="col-sm-2 col-form-label"><?= lang('Dashboard.tags') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="tags" data-tagin-enter placeholder="<?= lang('Dashboard.tags') ?>" data-tagin-placeholder="<?= lang('Dashboard.tags').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= $page->tags ?>">
                                                    <small class="text-info"><?= lang('Dashboard.separateWithAComma') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-3">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.pageSettings'); ?></h3>
                                <div class="card-tools">
                                </div>
                            </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.breadcrumbsImage') ?></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="breadcrumbs">
                                                        <label class="custom-file-label" for="breadcrumbs"><?= lang('Dashboard.chooseImage') ?></label>
                                                    </div>
                                                </div>
                                                <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                                <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 1920, 440 ]) ?></small><br>
                                                <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 2048 ]) ?></small>
                                            </div>
                                            <br>
                                            <div class="form-group">
                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $checked = "";
                                                            if($page->status == '1') $checked = "checked";
                                                            ?>
                                                            <input <?= $checked ?> name="status" type="checkbox"> <?= lang('Dashboard.enableThisPage') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeCreatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    <?php
                                    $session = session();
                                    $role_id = $session->role_id;
                                    if($role_id != 9 AND $role_id != 19)
                                    {
                                        ?>
                                        <input type="hidden" readonly name="type" value="1" required>
                                        <input type="hidden" name="old_breadcrumbs" readonly value="<?= $page->breadcrumbs ?>">
                                        <input type="hidden" name="id" readonly value="<?= $page->id ?>">
                                        <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.editPage') ?>"><?= lang('Dashboard.editPage') ?></button>
                                        <?php
                                    }else{
                                        ?>
                                        <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.editPage') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <!-- /.card-footer-->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
            </form>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>