<?php
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                        <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                        <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <?= view('App\Views\backend\common\notifications_view'); ?>
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-gradient-purple">
                        <div class="inner">
                            <h3><?= $totalUsers ?></h3>

                            <p><?= lang('Dashboard.totalUsers') ?></p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <a href="<?= base_url('dashboard/users-list') ?>" class="small-box-footer"><?= lang('Dashboard.moreInfo') ?> <i class="fas <?= lang('Dashboard.fa-arrow-circle-xxx') ?>"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-gradient-green">
                        <div class="inner">
                            <h3><?= $totalCategories ?></h3>

                            <p><?= lang('Dashboard.totalCategories') ?></p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-th-list"></i>
                        </div>
                        <a href="<?= base_url('dashboard/categories-list?keyword=Apps') ?>" class="small-box-footer"><?= lang('Dashboard.moreInfo') ?> <i class="fas <?= lang('Dashboard.fa-arrow-circle-xxx') ?>"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-gradient-cyan">
                        <div class="inner">
                            <h3><?= $totalFiles ?></h3>

                            <p><?= lang('Dashboard.totalFiles') ?></p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-sticky-note"></i>
                        </div>
                        <a href="<?= base_url('dashboard/files-list') ?>" class="small-box-footer"><?= lang('Dashboard.moreInfo') ?> <i class="fas <?= lang('Dashboard.fa-arrow-circle-xxx') ?>"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-gradient-red">
                        <div class="inner">
                            <h3><?= $totalAdvertising ?></h3>

                            <p><?= lang('Dashboard.advertisingList') ?></p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-ad"></i>
                        </div>
                        <a href="<?= base_url('dashboard/advertising-list') ?>" class="small-box-footer"><?= lang('Dashboard.moreInfo') ?> <i class="fas <?= lang('Dashboard.fa-arrow-circle-xxx') ?>"></i></a>
                    </div>
                </div>
                <!-- ./col -->
            </div>
            <!-- /.row -->
        </div>
    </section>
    <!-- /.content -->

    <!-- Billing / Transactions List Start -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-9">
                    <!-- Default box -->
                    <div class="card card-outline card-green" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.transactionsList') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/transactions-list') ?>" class="dropdown-item"><?= lang('Dashboard.transactionsList') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body table-responsive p-0">
                            <div style="height: 318px; overflow-y: scroll;">
                                <table class="table table-hover table-striped table-sm small text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.gateway') ?></th>
                                        <th><?= lang('Dashboard.amount') ?> (<?= $currenciesData->suffix ?? "" ?>)</th>
                                        <th><?= lang('Dashboard.transactionTracking') ?></th>
                                        <th><?= lang('Dashboard.description') ?></th>
                                        <th><?= lang('Dashboard.date') ?></th>
                                        
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($walletTransactions as $walletTransaction)
                                    {
                                        if($walletTransaction->transaction_type == "credit")
                                            $text_color = "text-success";
                                        else if($walletTransaction->transaction_type == "debit")
                                            $text_color = "text-danger";
                                        if($walletTransaction->transaction_tracking == null)
                                            $text_color = "text-gray";
                                        ?>
                                        <tr>
                                            <td>
                                                <a href="<?= $walletTransaction->user_id != 0 ? base_url('dashboard/user-profile/'.$walletTransaction->user_id) : '#' ?>">
                                                    <?= $walletTransaction->first_name . " " . $walletTransaction->last_name ?>
                                                </a>
                                            </td>
                                            <td class="align-middle"><?= $walletTransaction->payment_gateway_description ?></td>
                                            <td class="align-middle <?= $text_color ?>"><?= $currenciesData->prefix ?? "" ?> <?= number_format($walletTransaction->amount ?? 0, $currenciesData->decimals ?? 0, '.', ','); ?></td>
                                            <td class="align-middle"><?= $walletTransaction->transaction_tracking ?? "<span class='text-gray small'>" . lang('Dashboard.unsuccessful') . "</span>" ?></td>
                                            <td class="align-middle"><?= $walletTransaction->description ?></td>
                                            <td class="align-middle">
                                                <?php
                                                if($settingsData->calendar_type == "jDate")
                                                {
                                                    $transaction_date = $jdf->jdate('Y/m/d G:i', $walletTransaction->transaction_date, '', $settingsData->timezone);
                                                }else{
                                                    $transaction_date = Time::createFromTimestamp($walletTransaction->transaction_date, $settingsData->timezone, 'en_US');
                                                }
                                                ?>
                                                <?= $transaction_date ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-6 d-none">
                    <!-- Default box -->
                    <div class="card card-outline card-purple" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.registerFrom') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/users-activity') ?>" class="dropdown-item"><?= lang('Dashboard.usersActivity') ?></a>
                                        <a href="<?= base_url('dashboard/create-new-user') ?>" class="dropdown-item"><?= lang('Dashboard.createNewUser') ?></a>
                                        <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body p-0">
                            <div style="height: 318px;">

                                <div class="card-body">
                                    <div class="chart">
                                        <canvas id="incomeChart" style="min-height: 290px; height: 290px; max-height: 290px; max-width: 100%;"></canvas>
                                    </div>
                                </div>

                                <script>
                                    const ctxI = document.getElementById('incomeChart').getContext('2d');
                                    const incomeChart = new Chart(ctxI, {
                                        type: 'bar',
                                        data: {
                                            labels: ['<?= lang("Dashboard.today") ?>', '<?= lang("Dashboard.thisMonth") ?>', '<?= lang("Dashboard.thisYear") ?>', '<?= lang("Dashboard.total") ?>'],
                                            datasets: [{
                                                label: '<?= lang("Dashboard.successfulTransactions") ?>',
                                                data: ['<?= $totalSuccessfulTransactionsThisDay ?>', '<?= $totalSuccessfulTransactionsThisMonth ?>', '<?= $totalSuccessfulTransactionsThisYear ?>', '<?= $totalSuccessfulTransactions ?>'],
                                                backgroundColor: [
                                                    'rgba(40, 167, 69, 0.2)',
                                                    'rgba(40, 167, 69, 0.2)',
                                                    'rgba(40, 167, 69, 0.2)',
                                                    'rgba(40, 167, 69, 0.2)',
                                                ],
                                                borderColor: [
                                                    'rgba(40, 167, 69, 1)',
                                                    'rgba(40, 167, 69, 1)',
                                                    'rgba(40, 167, 69, 1)',
                                                    'rgba(40, 167, 69, 1)',
                                                ],
                                                borderWidth: 1
                                            },
                                            {
                                                label: '<?= lang("Dashboard.unsuccessfulTransactions") ?>',
                                                data: ['<?= $totalUnsuccessfulTransactionsThisDay ?>', '<?= $totalUnsuccessfulTransactionsThisMonth ?>', '<?= $totalUnsuccessfulTransactionsThisYear ?>', '<?= $totalUnsuccessfulTransactions ?>'],
                                                backgroundColor: [
                                                    'rgba(66, 66, 66, 0.2)',
                                                    'rgba(66, 66, 66, 0.2)',
                                                    'rgba(66, 66, 66, 0.2)',
                                                    'rgba(66, 66, 66, 0.2)',
                                                ],
                                                borderColor: [
                                                    'rgba(66, 66, 66, 1)',
                                                    'rgba(66, 66, 66, 1)',
                                                    'rgba(66, 66, 66, 1)',
                                                    'rgba(66, 66, 66, 1)',
                                                ],
                                                borderWidth: 1
                                            }
                                        ]
                                        },
                                        options: {
                                            scales: {
                                                y: {
                                                    beginAtZero: true
                                                }
                                            }
                                        }
                                    });
                                </script>

                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>


                <div class="col-md-3 p-0">
                    <!-- Widgets -->
                    <div class="col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-green"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisDay') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisDay, $currenciesData->decimals ?? 0, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?? "" ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisMonth') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisMonth, $currenciesData->decimals ?? 0, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?? "" ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-pink"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisYear') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisYear, $currenciesData->decimals ?? 0, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?? "" ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-black"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDeposited') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmount, $currenciesData->decimals ?? 0, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?? "" ?></span></span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- /.Billing / Transactions List End -->

    <!-- User Note / Users Activity Start -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
            <div class="col-md-4">
                    <!-- Default box -->
                    <div class="card card-outline card-orange" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.note') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">

                                </div>

                            </div>
                        </div>
                        <form class="form-horizontal" data-form-type="edit_user_note" data-action="<?= base_url('dashboard/perform-edit-user-note') ?>">
                            <?= csrf_field() ?>
                            <div class="card-body">
                                <div class="form-group row">
                                    <textarea rows="2" class="form-control" style="height: 109px;" name="user_note" placeholder="<?= lang('Dashboard.note') ?>"><?= $userNote->user_note ?></textarea>
                                </div>
                            </div>

                        <div class="card-footer">
                            <?php
                            $session = session();
                            $role_id = $session->role_id;
                            if($role_id != 9 AND $role_id != 19)
                            {
                                ?>
                                <input type="hidden" name="id" readonly required value="<?= service('uri')->getSegment(3) ?>">
                                <button type="submit" id="submitButton" class="submitButton btn btn-sm btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                <?php
                            }else{
                                ?>
                                <button type="button" disabled class="submitButton btn btn-sm btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                <?php
                            }
                            ?>
                        </div>
                        </form>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-8">
                    <!-- Default box -->
                    <div class="card card-outline card-gray" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.activity') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                        <a href="<?= base_url('dashboard/users-activity') ?>" class="dropdown-item"><?= lang('Dashboard.usersActivity') ?></a>
                                        <a href="<?= base_url('dashboard/create-new-user') ?>" class="dropdown-item"><?= lang('Dashboard.createNewUser') ?></a>
                                        <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body table-responsive p-0">
                            <div style="height: 220px; overflow-y: scroll;">
                                <table class="table table-hover table-striped table-sm text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.activity') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.time') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($activities as $activity)
                                    {
                                        $ip = $activity->ip;
                                        if($theRoleID == 9)
                                            $ip = 'xx.xx.xx.xx';
                                        ?>
                                        <tr class="i-text-small">
                                            <td>
                                                <a href="<?= $activity->user_id != 0 ? base_url('dashboard/user-profile/'.$activity->user_id) : '#' ?>">
                                                    <?= $activity->first_name . " " . $activity->last_name ?>
                                                </a>
                                            </td>
                                            <td><?= $activity->title; ?></td>
                                            <td><?= $activity->body; ?></td>
                                            <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $ip ?>" title="<?= $activity->agent ?>"><?= $ip ?></a></td>
                                            <td><?= timespan($activity->time, time(), 2)." ".lang('Date.ago'); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

            </div>
        </div>
    </section>
    <!-- /.User Note / Users Activity End -->

    <!-- User Note / Users Activity Start -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-5">
                    <!-- Default box -->
                    <div class="card card-outline card-purple" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.registerFrom') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/users-activity') ?>" class="dropdown-item"><?= lang('Dashboard.usersActivity') ?></a>
                                        <a href="<?= base_url('dashboard/create-new-user') ?>" class="dropdown-item"><?= lang('Dashboard.createNewUser') ?></a>
                                        <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body p-0">
                            <div style="height: 246px;">

                                <div class="card-body">
                                    <div class="chart">
                                        <canvas id="myChart" style="min-height: 220px; height: 220px; max-height: 200px; max-width: 100%;"></canvas>
                                    </div>
                                </div>

                                <script>
                                    const ctx = document.getElementById('myChart').getContext('2d');
                                    const myChart = new Chart(ctx, {
                                        type: 'bar',
                                        data: {
                                            labels: ['Dashboard', 'Website', 'Mobile PWA', 'Android', 'iOS', 'Installation'],
                                            datasets: [{
                                                label: 'Registered',
                                                data: [<?= $registerDashboard ?>, <?= $registerWebsite ?>, <?= $registerMobile ?>, <?= $registerAndroid ?>, <?= $registerIos ?>, <?= $registerInstallation ?>],
                                                backgroundColor: [
                                                    'rgba(255, 99, 132, 0.2)',
                                                    'rgba(54, 162, 235, 0.2)',
                                                    'rgba(255, 206, 86, 0.2)',
                                                    'rgba(75, 192, 192, 0.2)',
                                                    'rgba(153, 102, 255, 0.2)',
                                                    'rgba(255, 159, 64, 0.2)'
                                                ],
                                                borderColor: [
                                                    'rgba(255, 99, 132, 1)',
                                                    'rgba(54, 162, 235, 1)',
                                                    'rgba(255, 206, 86, 1)',
                                                    'rgba(75, 192, 192, 1)',
                                                    'rgba(153, 102, 255, 1)',
                                                    'rgba(255, 159, 64, 1)'
                                                ],
                                                borderWidth: 1
                                            }]
                                        },
                                        options: {
                                            scales: {
                                                y: {
                                                    beginAtZero: true
                                                }
                                            }
                                        }
                                    });
                                </script>

                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-4">
                    <div class="card card-outline card-yellow" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.appearanceSettings') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/website-templates') ?>" class="dropdown-item"><?= lang('Dashboard.websiteTemplates') ?></a>
                                        <a href="<?= base_url('dashboard/home-configuration') ?>" class="dropdown-item"><?= lang('Dashboard.homeConfiguration') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-body">
                            <div style="height: 85px;">
                                <p><?= lang('Dashboard.youAreUsingXForChangingWebsiteTemplate', [$settingsData->template_name]) ?> <a href="<?= base_url("dashboard/website-templates") ?>"><?= lang('Dashboard.clickHere') ?></a>.</p>
                                <p><?= lang('Dashboard.toConfigureHomePage') ?> <a href="<?= base_url("dashboard/home-configuration") ?>"><?= lang('Dashboard.clickHere') ?></a>.</p>
                            </div>
                        </div>
                    </div>

                    <div class="card" id="myCard">
                        <div class="card-body">
                            <div style="height: 65px;">
                                <p><?= lang('Dashboard.toAddOrEditLanguages') ?> <a href="<?= base_url("dashboard/languages") ?>"><?= lang('Dashboard.clickHere') ?></a>.</p>
                                <p><?= lang('Dashboard.toManageLogosAndImages') ?> <a href="<?= base_url("dashboard/logo-images") ?>"><?= lang('Dashboard.clickHere') ?></a>.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <!-- Default box -->
                    <div class="card card-outline card-pink" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.blogManagement') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/blog-comments-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersComments') ?></a>
                                        <a href="<?= base_url('dashboard/deleted-blog-comments-list') ?>" class="dropdown-item"><?= lang('Dashboard.deletedUsersComments') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body p-0">
                            <div style="height: 246px;">

                                <div class="pt-2 pb-2 pl-4 pr-4 mb-4">
                                    <a href="<?= base_url("dashboard/posts-list") ?>" type="button" class="btn btn-block btn-outline-info"><?= lang('Dashboard.postsList') ?></a>
                                    <a href="<?= base_url("dashboard/add-post") ?>" type="button" class="btn btn-block btn-outline-success"><?= lang('Dashboard.addNewPost') ?></a>
                                </div>

                                <ul class="nav flex-column">
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/blog-comments-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.pendingComments') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-warning"><?= $totalPendingPostComments ?></span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/blog-comments-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.approvedComments') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-success"><?= $totalApprovedPostComments ?></span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/deleted-blog-comments-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.deletedComments') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-danger"><?= $totalDeletedPostComments ?></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-9">
                    <!-- Default box -->
                    <div class="card card-outline card-info" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.downloadedFiles') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/downloaded-files') ?>" class="dropdown-item"><?= lang('Dashboard.downloadedFiles') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body table-responsive p-0">
                            <div style="height: 246px; overflow-y: scroll;">
                                <table class="table table-hover table-striped table-sm text-nowrap small">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.email') ?></th>
                                        <th><?= lang('Dashboard.file') ?></th>
                                        <th><?= lang('Dashboard.device') ?></th>
                                        <th class="d-none"><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.firstDownload') ?></th>
                                        <th><?= lang('Dashboard.lastDownload') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($downloadedFiles as $file)
                                    {
                                        if($settingsData->calendar_type == "jDate")
                                        {
                                            $created_at = $jdf->jdate('Y/m/d G:i', $file->created_at, '', $settingsData->timezone);
                                            $updated_at = $jdf->jdate('Y/m/d G:i', $file->updated_at, '', $settingsData->timezone);
                                        }else{
                                            $created_at = Time::createFromTimestamp($file->created_at, $settingsData->timezone, 'en_US');
                                            $updated_at = Time::createFromTimestamp($file->updated_at, $settingsData->timezone, 'en_US');
                                        }
                                        $file_ip = $file->ip;
                                        if($theRoleID == 9)
                                            $file_ip = 'xx.xx.xx.xx';
                                        ?>
                                        <tr>
                                            <?php
                                            if($file->user_id != 0) {
                                            ?>
                                            <td class="align-middle"><a href="<?= base_url('dashboard/user-profile/'.$file->user_id) ?>"><?= $file->first_name." ".$file->last_name ?></a></td>
                                            <?php
                                            }else{
                                            ?>
                                            <td class="align-middle"><?= $file->first_name ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td class="align-middle"><?= $file->email ?></td>
                                            <td><a target="_blank" title="<?= $file->file_title ?>" href="<?= base_url("file-details/$file->content_id/$file->file_title_slug?id=$file->content_id") ?>"</a><?= $file->file_title ?></td>
                                            <td><?= $file->device_type_title; ?></td>
                                            <td class="d-none"><a target="_blank" href="https://extreme-ip-lookup.com/<?= $file_ip ?>" title="<?= $file->agent ?>"><?= $file_ip ?></a></td>
                                            <td><?= $created_at; ?></td>
                                            <td><?= $updated_at; ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($downloadedFiles)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>


                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                
                <div class="col-md-3">
                    <!-- Default box -->
                    <div class="card card-outline card-primary" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.downloadManagement') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/files-list') ?>" class="dropdown-item"><?= lang('Dashboard.filesList') ?></a>
                                        <a href="<?= base_url('dashboard/add-app-file') ?>" class="dropdown-item"><?= lang('Dashboard.addAppFile') ?></a>
                                        <a href="<?= base_url('dashboard/add-game-file') ?>" class="dropdown-item"><?= lang('Dashboard.addGameFile') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body p-0">
                            <div style="height: 246px;">

                                <div class="pt-2 pb-2 pl-4 pr-4 mb-4">
                                    <a href="<?= base_url("dashboard/files-list") ?>" type="button" class="btn btn-block btn-outline-info"><?= lang('Dashboard.filesList') ?></a>
                                    <div class="btn-group btn-block">
                                        <a type="button" href="<?= base_url("dashboard/add-app-file") ?>" class="btn btn-outline-success"><?= lang('Dashboard.addAppFile') ?></a>
                                        <a type="button" href="<?= base_url("dashboard/add-game-file") ?>" class="btn btn-outline-success"><?= lang('Dashboard.addGameFile') ?></a>
                                    </div>
                                </div>

                                <ul class="nav flex-column">
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/contents-reviews-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.pendingReviews') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-warning"><?= $totalPendingContentsReviews ?></span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/contents-reviews-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.approvedReviews') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-success"><?= $totalApprovedContentsReviews ?></span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?= base_url("dashboard/deleted-contents-reviews-list") ?>" class="nav-link">
                                            <?= lang('Dashboard.deletedUsersReviews') ?> <span class="<?= lang('Dashboard.float-xxx') ?> badge bg-danger"><?= $totalDeletedContentsReviews ?></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

            </div>
        </div>
    </section>
    <!-- /.User Note / Users Activity End -->


</div>
<!-- /.content-wrapper -->

<script>
    //-------------
    //- BAR CHART -
    //-------------
    var barChartCanvas = $('#barChart').get(0).getContext('2d')
    var barChartData = $.extend(true, {}, areaChartData)
    var temp0 = areaChartData.datasets[0]
    var temp1 = areaChartData.datasets[1]
    barChartData.datasets[0] = temp1
    barChartData.datasets[1] = temp0

    var barChartOptions = {
      responsive              : true,
      maintainAspectRatio     : false,
      datasetFill             : false
    }

    new Chart(barChartCanvas, {
      type: 'bar',
      data: barChartData,
      options: barChartOptions
    })
</script>
<?= $this->endSection() ?>