<?php
$uri = service('uri');
$active_segment = $uri->getSegment(2);
$active = "active";
$menuOpen = "menu-open";
$status = $_GET['status'] ?? '';

$db = db_connect();
$builder = $db->table('mod_support_tickets_tbl');
$builder->where('status', 'Open');
$builder->orWhere('status', 'User_Reply');
$totalTickets = $builder->countAllResults();
$db->close();
if($totalTickets == 0 || $totalTickets == null)
    $displayTicketsCount = "d-none";

// Check if "Support Module" is exist
$supportModulePath = ROOTPATH . "modules/addons/Support/support_module.yaml";
if (file_exists($supportModulePath)) {
    $showSupportModuleMenu = "";
} else {
    $showSupportModuleMenu = "d-none";
}
?>
<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?= base_url('dashboard/home') ?>" class="brand-link elevation-4">
        <img src="<?= base_url('backend/assets/uploads/admins/images/'.$settingsData->dashboard_logo) ?>" alt="<?= $settingsData->app_name ?>" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light"><?= $settingsData->app_name ?></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user (optional) -->
        <br>
        <!-- SidebarSearch Form -->
        <div class="form-inline">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="<?= lang('Dashboard.search') ?>" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar nav-child-indent flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="<?= base_url('dashboard/home') ?>" class="nav-link <?php if($active_segment == "home") echo $active; ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p><?= lang('Dashboard.dashboard') ?></p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?= base_url('dashboard/profile') ?>" class="nav-link <?php if($active_segment == "profile") echo $active; ?>">
                        <i class="nav-icon fas fa-user"></i>
                        <p><?= lang('Dashboard.myProfile') ?></p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?= base_url('dashboard/wallet') ?>" class="nav-link <?php if($active_segment == "wallet") echo $active; ?>">
                        <i class="nav-icon fas fa-wallet"></i>
                        <p><?= lang('Dashboard.wallet') ?></p><span class="<?= lang('Dashboard.align-xxx') ?> badge badge-success"> <?= $currenciesData->prefix ?? "" ?> <?= number_format($walletData->credit ?? 0, $currenciesData->decimals ?? 0, '.', ','); ?> <?= $currenciesData->suffix ?? "" ?></span>
                    </a>
                </li>

                <!-- Billing -->
                <li class="nav-item <?php if($active_segment == "transactions-list") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "transactions-list") echo $active; ?>">
                        <i class="nav-icon fas fa-solid fa-file-invoice-dollar"></i>
                        <p><?= lang('Dashboard.billing') ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/transactions-list') ?>" class="nav-link <?php if($active_segment == "transactions-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.transactionsList') ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Users -->
                <li class="nav-item <?php if($active_segment == "users-list" OR $active_segment == "soft-deleted-users-list" OR $active_segment == "create-new-user" OR $active_segment == "users-activity" OR $active_segment == "user-profile" OR $active_segment == "user-roles" OR $active_segment == "edit-role" OR $active_segment == "users-packages" OR $active_segment == "edit-users-package") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "users-list" OR $active_segment == "soft-deleted-users-list" OR $active_segment == "create-new-user" OR $active_segment == "users-activity" OR $active_segment == "user-roles"  OR $active_segment == "edit-role" OR $active_segment == "users-packages" OR $active_segment == "edit-users-package") echo $active; ?>">
                        <i class="nav-icon fas fa-users"></i>
                        <p><?= lang('Dashboard.usersManagement') ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/users-list') ?>" class="nav-link <?php if($active_segment == "users-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersList') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/soft-deleted-users-list') ?>" class="nav-link <?php if($active_segment == "soft-deleted-users-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.deletedUsersList') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/create-new-user') ?>" class="nav-link <?php if($active_segment == "create-new-user") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.createNewUser') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/user-roles') ?>" class="nav-link <?php if($active_segment == "user-roles") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.userRoles') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/users-packages') ?>" class="nav-link <?php if($active_segment == "users-packages") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersPackages') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/users-activity') ?>" class="nav-link <?php if($active_segment == "users-activity") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersActivity') ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Support Module -->
                <li class="nav-item <?= $showSupportModuleMenu ?> <?php if($active_segment == "support-tickets" OR $active_segment == "ticket-details" OR $active_segment == "send-ticket" OR $active_segment == "support-departments" OR $active_segment == "edit-support-department" OR $active_segment == "edit-ticket-reply") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "support-tickets" OR $active_segment == "ticket-details" OR $active_segment == "send-ticket" OR $active_segment == "support-departments" OR $active_segment == "edit-support-department" OR $active_segment == "edit-ticket-reply") echo $active; ?>">
                        <i class="nav-icon far fa-life-ring"></i>
                        <p><?= lang('Dashboard.support') ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i> <span class="badge badge-danger <?= $displayTicketsCount ?? '' ?> <?= lang('Dashboard.align-xxx') ?>"><?= $totalTickets ?></span></p>
                    </a>

                    <!-- Support Tickets -->
                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "support-tickets") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "support-tickets") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.supportTickets'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=All') ?>" class="nav-link <?php if($status == "All") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.allTickets'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=Open') ?>" class="nav-link <?php if($status == "Open") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.open'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=Closed') ?>" class="nav-link <?php if($status == "Closed") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.closed'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=Answered') ?>" class="nav-link <?php if($status == "Answered") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.answered'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=User_Reply') ?>" class="nav-link <?php if($status == "User_Reply") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.userReply'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=In_Progress') ?>" class="nav-link <?php if($status == "In_Progress") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.inProgress'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/support-tickets/?status=On_Hold') ?>" class="nav-link <?php if($status == "On_Hold") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.onHold'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/support-departments') ?>" class="nav-link <?php if($active_segment == "support-departments") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.departments') ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Categories -->
                <li class="nav-item has-treeview <?php if($active_segment == "create-category" OR $active_segment == "categories-list" OR $active_segment == "edit-category") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "create-category" OR $active_segment == "categories-list" OR $active_segment == "edit-category") echo $active; ?>">
                        <i class="nav-icon fas fa-th-list"></i>
                        <p><?= lang('Dashboard.categories'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <?php
                            $keyword = "";
                            if(isset($_GET['keyword']))
                                $keyword = $_GET['keyword'];
                            ?>

                            <a href="<?= base_url('dashboard/categories-list?keyword=Apps') ?>" class="nav-link <?php if($keyword == "Apps") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.appsCategories'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/categories-list?keyword=Games') ?>" class="nav-link <?php if($keyword == "Games") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.gamesCategories'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/categories-list?keyword=Blog') ?>" class="nav-link <?php if($keyword == "Blog") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.blogCategories'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/create-category') ?>" class="nav-link <?php if($active_segment == "create-category") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.createCategory'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Content -->
                <li class="nav-item has-treeview <?php if($active_segment == "files-list" OR $active_segment == "files-list-pending" OR $active_segment == "add-app-file" OR $active_segment == "add-game-file" OR $active_segment == "edit-app-file" OR $active_segment == "edit-game-file" OR $active_segment == "contents-reviews-list" OR $active_segment == "edit-contents-review" OR $active_segment == "deleted-contents-reviews-list" OR $active_segment == "downloaded-files" OR $active_segment == "not-checked-report" OR $active_segment == "checked-report" OR $active_segment == "images-gallery") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "files-list" OR $active_segment == "files-list-pending" OR $active_segment == "add-app-file" OR $active_segment == "add-game-file" OR $active_segment == "edit-app-file" OR $active_segment == "edit-game-file" OR $active_segment == "contents-reviews-list" OR $active_segment == "edit-contents-review" OR $active_segment == "deleted-contents-reviews-list" OR $active_segment == "downloaded-files" OR $active_segment == "not-checked-report" OR $active_segment == "checked-report" OR $active_segment == "images-gallery") echo $active; ?>">
                        <i class="nav-icon fas fa-download"></i>
                        <p><?= lang('Dashboard.downloadManagement'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/files-list') ?>" class="nav-link <?php if($active_segment == "files-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.filesList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/files-list-pending') ?>" class="nav-link <?php if($active_segment == "files-list-pending") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.filesListPending'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-app-file') ?>" class="nav-link <?php if($active_segment == "add-app-file") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addAppFile'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-game-file') ?>" class="nav-link <?php if($active_segment == "add-game-file") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addGameFile'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/downloaded-files') ?>" class="nav-link <?php if($active_segment == "downloaded-files") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.downloadedFiles'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "contents-reviews-list" OR $active_segment == "edit-contents-review" OR $active_segment == "deleted-contents-reviews-list") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "contents-reviews-list" OR $active_segment == "edit-contents-review" OR $active_segment == "deleted-contents-reviews-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersReviews'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/contents-reviews-list') ?>" class="nav-link <?php if($active_segment == "contents-reviews-list") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.reviews'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/deleted-contents-reviews-list') ?>" class="nav-link <?php if($active_segment == "deleted-contents-reviews-list") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.deletedUsersReviews'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>

                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "not-checked-report" OR $active_segment == "checked-report") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "not-checked-report" OR $active_segment == "checked-report") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.reportsAbuse'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/not-checked-report') ?>" class="nav-link <?php if($active_segment == "not-checked-report") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.notCheckedReports'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/checked-report') ?>" class="nav-link <?php if($active_segment == "checked-report") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.checkedReports'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <!-- Blog -->
                <li class="nav-item has-treeview <?php if($active_segment == "posts-list" OR $active_segment == "add-post" OR $active_segment == "edit-post" OR $active_segment == "soft-deleted-posts-list" OR $active_segment == "blog-comments-list" OR $active_segment == "deleted-blog-comments-list" OR $active_segment == "edit-blog-comment") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "posts-list" OR $active_segment == "add-post" OR $active_segment == "edit-post" OR $active_segment == "soft-deleted-posts-list" OR $active_segment == "blog-comments-list" OR $active_segment == "deleted-blog-comments-list" OR $active_segment == "edit-blog-comment") echo $active; ?>">
                        <i class="nav-icon fas fa-sticky-note"></i>
                        <p><?= lang('Dashboard.blogManagement'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/posts-list') ?>" class="nav-link <?php if($active_segment == "posts-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.postsList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/soft-deleted-posts-list') ?>" class="nav-link <?php if($active_segment == "soft-deleted-posts-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.deletedPostsList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-post') ?>" class="nav-link <?php if($active_segment == "add-post") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addNewPost'); ?></p>
                            </a>
                        </li>
                    </ul>

                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "blog-comments-list" OR $active_segment == "deleted-blog-comments-list" OR $active_segment == "edit-blog-comment") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "blog-comments-list" OR $active_segment == "deleted-blog-comments-list" OR $active_segment == "edit-blog-comment") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersComments'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/blog-comments-list') ?>" class="nav-link <?php if($active_segment == "blog-comments-list") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.comments'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/deleted-blog-comments-list') ?>" class="nav-link <?php if($active_segment == "deleted-blog-comments-list") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.deletedComments'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <!-- Pages -->
                <li class="nav-item has-treeview <?php if($active_segment == "static-page-terms" OR $active_segment == "static-page-privacy" OR $active_segment == "static-page-about" OR $active_segment == "dynamic-pages" OR $active_segment == "add-dynamic-page" OR $active_segment == "static-page-advertisement" OR $active_segment == "add-page" OR $active_segment == "pages-list" OR $active_segment == "edit-page") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "static-page-terms" OR $active_segment == "static-page-privacy" OR $active_segment == "static-page-about" OR $active_segment == "dynamic-pages" OR $active_segment == "add-dynamic-page" OR $active_segment == "static-page-advertisement" OR $active_segment == "add-page" OR $active_segment == "pages-list" OR $active_segment == "edit-page") echo $active; ?>">
                        <i class="nav-icon fas fa-file-alt"></i>
                        <p><?= lang('Dashboard.pages'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "static-page-terms" OR $active_segment == "static-page-privacy" OR $active_segment == "static-page-about" OR $active_segment == "static-page-advertisement") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "static-page-terms" OR $active_segment == "static-page-privacy" OR $active_segment == "static-page-about" OR $active_segment == "static-page-advertisement") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.staticPages'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/static-page-terms') ?>" class="nav-link <?php if($active_segment == "static-page-terms") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.termsAndConditions'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/static-page-privacy') ?>" class="nav-link <?php if($active_segment == "static-page-privacy") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.privacyPolicy'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/static-page-about') ?>" class="nav-link <?php if($active_segment == "static-page-about") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.aboutUs'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/static-page-advertisement') ?>" class="nav-link <?php if($active_segment == "static-page-advertisement") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.advertisement'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/pages-list') ?>" class="nav-link <?php if($active_segment == "pages-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.dynamicPages'); ?></p>
                            </a>
                        </li>
                    </ul>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-page') ?>" class="nav-link <?php if($active_segment == "add-page") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addDynamicPage'); ?></p>
                            </a>
                        </li>
                    </ul>

                </li>

                <!-- Testimonials -->
                <li class="nav-item <?php if($active_segment == "testimonials" OR $active_segment == "add-testimonials" OR $active_segment == "edit-testimonials") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "testimonials" OR $active_segment == "add-testimonials" OR $active_segment == "edit-testimonials") echo $active; ?>">
                        <i class="nav-icon fas fa-comments"></i>
                        <p><?= lang('Dashboard.testimonials') ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/testimonials') ?>" class="nav-link <?php if($active_segment == "testimonials") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.usersTestimonials') ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-testimonials') ?>" class="nav-link <?php if($active_segment == "add-testimonials") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addTestimonials') ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Advertising -->
                <li class="nav-item has-treeview <?php if($active_segment == "advertising-list" OR $active_segment == "create-new-ad" OR $active_segment == "edit-ad" OR $active_segment == "admob-configuration" OR $active_segment == "tapsell-plus-configuration") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "advertising-list" OR $active_segment == "create-new-ad" OR $active_segment == "edit-ad" OR $active_segment == "admob-configuration" OR $active_segment == "tapsell-plus-configuration") echo $active; ?>">
                        <i class="nav-icon fas fa-ad"></i>
                        <p><?= lang('Dashboard.advertisingManagement'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/advertising-list') ?>" class="nav-link <?php if($active_segment == "advertising-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.advertisingList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/create-new-ad') ?>" class="nav-link <?php if($active_segment == "create-new-ad") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.createNewAd'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Images Slider -->
                <li class="nav-item has-treeview <?php if($active_segment == "images-slider-list" OR $active_segment == "add-image-slider" OR $active_segment == "edit-image-slider") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "images-slider-list" OR $active_segment == "add-image-slider" OR $active_segment == "edit-image-slider") echo $active; ?>">
                        <i class="nav-icon fas fa-images"></i>
                        <p><?= lang('Dashboard.imagesSlider'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/images-slider-list') ?>" class="nav-link <?php if($active_segment == "images-slider-list") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.imagesSliderList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-image-slider') ?>" class="nav-link <?php if($active_segment == "add-image-slider") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addImageSlider'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Push Notification -->
                <li class="nav-item has-treeview <?php if($active_segment == "sending-push-notification-from-onesignal") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "sending-push-notification-from-onesignal") echo $active; ?>">
                        <i class="nav-icon fas fa-paper-plane"></i>
                        <p><?= lang('Dashboard.pushNotification'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/sending-push-notification-from-onesignal') ?>" class="nav-link <?php if($active_segment == "sending-push-notification-from-onesignal") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.oneSignal'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Mass Email -->
                <li class="nav-item has-treeview <?php if($active_segment == "sending-newsletter" OR $active_segment == "sending-email") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "sending-newsletter" OR $active_segment == "sending-email") echo $active; ?>">
                        <i class="nav-icon fas fa-envelope"></i>
                        <p><?= lang('Dashboard.massEmail'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/sending-newsletter') ?>" class="nav-link <?php if($active_segment == "sending-newsletter") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.sendingNewsletter'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/sending-email') ?>" class="nav-link <?php if($active_segment == "sending-email") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.sendingEmail'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- System -->
                <li class="nav-item has-treeview <?php if($active_segment == "system-cleanup" OR $active_segment == "database-status" OR $active_segment == "php-info" OR $active_segment == "license-information") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "system-cleanup" OR $active_segment == "database-status" OR $active_segment == "php-info" OR $active_segment == "license-information") echo $active; ?>">
                        <i class="nav-icon fas fa-cog"></i>
                        <p><?= lang('Dashboard.system'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/system-cleanup') ?>" class="nav-link <?php if($active_segment == "system-cleanup") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.systemCleanup'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/database-status') ?>" class="nav-link <?php if($active_segment == "database-status") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.databaseStatus'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/php-info') ?>" class="nav-link <?php if($active_segment == "php-info") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.phpInfo'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/license-information') ?>" class="nav-link <?php if($active_segment == "license-information") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.licenseInformation'); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Settings -->
                <li class="nav-item has-treeview <?php if($active_segment == "general-settings" OR $active_segment == "logo-images" OR $active_segment == "version-control" OR $active_segment == "add-version" OR $active_segment == "edit-version" OR $active_segment == "email-settings" OR $active_segment == "languages" OR $active_segment == "api-docs" OR $active_segment == "website-templates" OR $active_segment == "home-configuration" OR $active_segment == "currency-unit" OR $active_segment == "payment-gateways" OR $active_segment == "edit-payment-gateway" OR $active_segment == "edit-merchant-key" OR $active_segment == "daily-exchange-rate") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "general-settings" OR $active_segment == "logo-images" OR $active_segment == "version-control" OR $active_segment == "add-version" OR $active_segment == "edit-version" OR $active_segment == "email-settings" OR $active_segment == "languages" OR $active_segment == "api-docs" OR $active_segment == "website-templates" OR $active_segment == "home-configuration" OR $active_segment == "currency-unit" OR $active_segment == "payment-gateways" OR $active_segment == "edit-payment-gateway" OR $active_segment == "edit-merchant-key" OR $active_segment == "daily-exchange-rate") echo $active; ?>">
                        <i class="nav-icon fas fa-tools"></i>
                        <p><?= lang('Dashboard.settings'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/general-settings') ?>" class="nav-link <?php if($active_segment == "general-settings") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.generalSettings'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/website-templates') ?>" class="nav-link <?php if($active_segment == "website-templates") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.websiteTemplates'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/home-configuration') ?>" class="nav-link <?php if($active_segment == "home-configuration") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.homeConfiguration'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/email-settings') ?>" class="nav-link <?php if($active_segment == "email-settings") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.emailSettings'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/languages') ?>" class="nav-link <?php if($active_segment == "languages") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.languages'); ?></p>
                            </a>
                        </li>
                    </ul>

                    <!-- Finance and Payment -->
                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "currency-unit" OR $active_segment == "payment-gateways" OR $active_segment == "edit-payment-gateway" OR $active_segment == "edit-merchant-key" OR $active_segment == "daily-exchange-rate") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "currency-unit" OR $active_segment == "payment-gateways" OR $active_segment == "edit-payment-gateway" OR $active_segment == "edit-merchant-key" OR $active_segment == "daily-exchange-rate") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.financeAndPayment'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/currency-unit') ?>" class="nav-link <?php if($active_segment == "currency-unit") echo $active; ?>">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.currencyUnit'); ?></p>
                                    </a>
                                </li>
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/payment-gateways') ?>" class="nav-link <?php if($active_segment == "payment-gateways") echo $active; ?>">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.paymentGateways'); ?></p>
                                    </a>
                                </li>
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/daily-exchange-rate') ?>" class="nav-link <?php if($active_segment == "daily-exchange-rate") echo $active; ?>">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.dailyExchangeRate'); ?></p>
                                    </a>
                                </li>
                            </ul>

                        </li>
                    </ul>

                    
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/logo-images') ?>" class="nav-link <?php if($active_segment == "logo-images") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.logoImages'); ?></p>
                            </a>
                        </li>
                    </ul>

                    <!-- Version Control -->
                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "version-control" OR $active_segment == "add-version" OR $active_segment == "edit-version") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "version-control" OR $active_segment == "add-version" OR $active_segment == "edit-version") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.versionControl'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/version-control') ?>" class="nav-link <?php if($active_segment == "version-control") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.versionsList'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/add-version') ?>" class="nav-link <?php if($active_segment == "add-version") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.addVersion'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                    
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/profile?active_tab=api_key') ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.apiKey'); ?></p>
                            </a>
                        </li>
                    </ul>
                    
                </li>

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>