<?php
$uri = service('uri');
$active_segment = $uri->getSegment(2);
$active = "active";
$menuOpen = "menu-open";
$status = $_GET['status'] ?? '';

$db = db_connect();
$query = $db->table('mod_support_tickets_tbl');
$totalTickets = $query->where('user_id', $userId)->where('status !=', 'Closed')->where('status !=', 'Open')->where('status !=', 'User_Reply')->where('read_by_user', 'No')->where('deleted_at', null)->countAllResults();
$db->close();
if($totalTickets == 0 || $totalTickets == null)
    $displayTicketsCount = "d-none";

// Check if "Support Module" is exist
$supportModulePath = ROOTPATH . "modules/addons/Support/support_module.yaml";
if (file_exists($supportModulePath)) {
    $showSupportModuleMenu = "";
} else {
    $showSupportModuleMenu = "d-none";
}
?>
<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?= base_url('dashboard/home') ?>" class="brand-link elevation-4">
        <img src="<?= base_url('backend/assets/uploads/admins/images/'.$settingsData->dashboard_logo) ?>" alt="<?= $settingsData->app_name ?>" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light"><?= $settingsData->app_name ?></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user (optional) -->
        <br>
        <!-- SidebarSearch Form -->
        <div class="form-inline">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="<?= lang('Dashboard.search') ?>" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar nav-child-indent flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
                     with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="<?= base_url('dashboard/home') ?>" class="nav-link <?php if($active_segment == "home") echo $active; ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p><?= lang('Dashboard.dashboard') ?></p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?= base_url('dashboard/profile') ?>" class="nav-link <?php if($active_segment == "profile") echo $active; ?>">
                        <i class="nav-icon fas fa-user"></i>
                        <p><?= lang('Dashboard.myProfile') ?></p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?= base_url('dashboard/wallet') ?>" class="nav-link <?php if($active_segment == "wallet") echo $active; ?>">
                        <i class="nav-icon fas fa-wallet"></i>
                        <p><?= lang('Dashboard.wallet') ?></p><span class="<?= lang('Dashboard.align-xxx') ?> badge badge-success"> <?= $currenciesData->prefix ?? "" ?> <?= number_format($walletData->credit ?? 0, $currenciesData->decimals ?? 0, '.', ','); ?> <?= $currenciesData->suffix ?? "" ?></span>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?= base_url('dashboard/profile?active_tab=user_role') ?>" class="nav-link">
                        <i class="nav-icon fas fa-user-check"></i>
                        <p><?= lang('Dashboard.upgradeUserRole') ?></p>
                    </a>
                </li>

                <!-- Support Module -->
                <li class="nav-item <?= $showSupportModuleMenu ?> <?php if($active_segment == "send-ticket-user" OR $active_segment == "my-tickets" OR $active_segment == "ticket-details-user") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "send-ticket-user" OR $active_segment == "my-tickets" OR $active_segment == "ticket-details-user") echo $active; ?>">
                        <i class="nav-icon far fa-life-ring"></i>
                        <p><?= lang('Dashboard.support') ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i> <span class="badge badge-danger <?= $displayTicketsCount ?? '' ?> <?= lang('Dashboard.align-xxx') ?>"><?= $totalTickets ?></span></p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/send-ticket-user') ?>" class="nav-link <?php if($active_segment == "send-ticket-user") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.sendTicket') ?></p>
                            </a>
                        </li>
                    </ul>

                    <!-- Support Tickets -->
                    <ul class="nav nav-treeview">
                        <li class="nav-item <?php if($active_segment == "my-tickets") echo $menuOpen; ?>">
                            <a href="#" class="nav-link <?php if($active_segment == "my-tickets") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.myTickets'); ?><i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=All') ?>" class="nav-link <?php if($status == "All") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.allTickets'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=Open') ?>" class="nav-link <?php if($status == "Open") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.open'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=Closed') ?>" class="nav-link <?php if($status == "Closed") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.closed'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=Answered') ?>" class="nav-link <?php if($status == "Answered") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.answered'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=User_Reply') ?>" class="nav-link <?php if($status == "User_Reply") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.userReply'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=In_Progress') ?>" class="nav-link <?php if($status == "In_Progress") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.inProgress'); ?></p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?= base_url('dashboard/my-tickets/?status=On_Hold') ?>" class="nav-link <?php if($status == "On_Hold") echo $active; ?>">
                                        <i class="far fa-dot-circle nav-icon"></i>
                                        <p><?= lang('Dashboard.onHold'); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <!-- Content -->
                <li class="nav-item has-treeview <?php if($active_segment == "files-list-user" OR $active_segment == "add-app-file-user" OR $active_segment == "add-game-file-user" OR $active_segment == "edit-app-file-user" OR $active_segment == "edit-game-file-user" OR $active_segment == "images-gallery") echo $menuOpen; ?>">
                    <a href="#" class="nav-link <?php if($active_segment == "files-list-user" OR $active_segment == "add-app-file-user" OR $active_segment == "add-game-file-user" OR $active_segment == "edit-app-file-user" OR $active_segment == "edit-game-file-user" OR $active_segment == "images-gallery") echo $active; ?>">
                        <i class="nav-icon fas fa-download"></i>
                        <p><?= lang('Dashboard.downloadManagement'); ?>
                            <i class="<?= lang('Dashboard.align-xxx') ?> fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/files-list-user') ?>" class="nav-link <?php if($active_segment == "files-list-user") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.filesList'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-app-file-user') ?>" class="nav-link <?php if($active_segment == "add-app-file-user") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addAppFile'); ?></p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?= base_url('dashboard/add-game-file-user') ?>" class="nav-link <?php if($active_segment == "add-game-file-user") echo $active; ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?= lang('Dashboard.addGameFile'); ?></p>
                            </a>
                        </li>
                    </ul>

                </li>

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>