<?php

use App\Models\Backend\CategoryModel;
$categoryModel = new CategoryModel();

?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.blogManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/posts-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                <table class="table table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.id') ?></th>
                                        <th><?= lang('Dashboard.author') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.category') ?></th>
                                        <th><?= lang('Dashboard.views') ?></th>
                                        <th><?= lang('Dashboard.image') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($posts as $post)
                                    {
                                        $status = "<span class='badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($post->status == 0) $status = "<span class='center badge badge-warning'>".lang('Dashboard.unpublished')."</span>";
                                        if($post->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.published')."</span>";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $post->id ?></td>
                                            <td class="align-middle"><a href="<?= base_url("dashboard/user-profile/$post->user_id") ?>"><?= $post->first_name." ".$post->last_name ?></a></td>
                                            <td class="align-middle"><?= $post->title ?></td>
                                            <td class="align-middle"><?= $post->category_title; ?></td>
                                            <td class="align-middle"><?= $post->views; ?></td>
                                            <td class="align-middle"><img width="60px" height="auto" src="<?= base_url("backend/assets/uploads/admins/blog/thumb/$post->image") ?>" class="img-rounded" alt="<?= lang('Dashboard.image') ?>"></td>
                                            <td class="align-middle"><?= $status ?></td>
                                            <td class="align-middle" style="width: 118px;">
                                                <a title="<?= lang('Dashboard.show') ?>" target="_blank" href="<?= base_url('post-details/'.$post->id.'/'.$post->title_slug) ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>
                                                <a title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/edit-post/'.$post->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>
                                                <a title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-post/'.$post->id); ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" class="text-danger p-1">&nbsp;<i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($posts)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>