<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersComments') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-8">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/blog-comments-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersComments') ?></a>
                                            <a href="<?= base_url('dashboard/deleted-blog-comments-list') ?>" class="dropdown-item"><?= lang('Dashboard.deletedUsersComments') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-blog-comment') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="comment" class="col-sm-2 col-form-label"><?= lang('Dashboard.comment') ?> *</label>
                                        <div class="col-sm-10">
                                            <textarea rows="6" class="form-control" name="comment" required placeholder="<?= lang('Dashboard.comment') ?>"><?= $comment->comment ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" readonly name="id" value="<?= $comment->id ?>">
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.edit') ?>"><?= lang('Dashboard.edit') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.edit') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>