<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('tags-input-header') ?>
<!-- Tags Input: https://github.com/erwinheldy/tagin -->
    <link rel="stylesheet" href="<?= base_url('backend/assets/dist/css/tagin/tagin.min.css'); ?>">
<?= $this->endSection() ?>

<?= $this->section('tags-input-footer') ?>
    <!-- Tags Input -->
    <script src="<?= base_url('backend/assets/dist/js/tagin/tagin.min.js'); ?>"></script>
    <script>
        document.querySelectorAll('.tagin:not([id])').forEach((el) => {
            if (el instanceof HTMLInputElement) {
                const tagin = new Tagin(el)
            }
        })

        const testAdd = new Tagin(document.getElementById('test-add'))
        document.getElementById('add1').addEventListener('click', function () {
            testAdd.addTag('yellow')
            this.remove()
        })
        document.getElementById('add2').addEventListener('click', function () {
            testAdd.addTag(['cyan', 'black'])
            this.remove()
        })

        const testValue = new Tagin(document.getElementById('test-value'))
        document.getElementById('get').addEventListener('click', function () {
            const value = testValue.getTag()
            const values = JSON.stringify(testValue.getTags())
            document.getElementById('value-container').innerHTML = `${value}<br>${values}`
        })


        // Example starter JavaScript for disabling form submissions if there are invalid fields
        void (function() {
            document.querySelectorAll('.needs-validation').forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }

                    form.classList.add('was-validated')
                })
            })
        })()
    </script>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.blogManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <form class="form-horizontal" action="<?= base_url('dashboard/perform-add-post') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                    <?= csrf_field() ?>
                <div class="row">
                    <div class="col-md-9">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/posts-list') ?>" class="dropdown-item"><?= lang('Dashboard.postsList') ?></a>
                                            <a href="<?= base_url('dashboard/categories-list') ?>" class="dropdown-item"><?= lang('Dashboard.categoriesList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>

                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.postTitle') ?> *</label>
                                                <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= old('title') ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.postTitleSlug') ?> *</label>
                                                <input type="text" class="form-control" name="title_slug" id="title_slug" disabled placeholder="<?= lang('Dashboard.postTitleSlug') ?>" value="<?= lang('Dashboard.thisFieldIsCompletedAutomatically') ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.postContents') ?> *</label>
                                                <br>
                                                <textarea name="post_contents" id="summernote"><?= old('post_contents') ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <br>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="description" class="col-sm-2 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="description" id="description" placeholder="<?= lang('Dashboard.description') ?>" value="<?= old('description') ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaDescriptionText') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="keywords" class="col-sm-2 col-form-label"><?= lang('Dashboard.keywords') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="keywords" data-tagin-enter placeholder="<?= lang('Dashboard.keywords') ?>" data-tagin-placeholder="<?= lang('Dashboard.keywords').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= old('keywords') ?>">
                                                    <small class="text-info"><?= lang('Dashboard.seoMetaKeywords') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="tags" class="col-sm-2 col-form-label"><?= lang('Dashboard.tags') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control shadow-none tagin" name="tags" data-tagin-enter placeholder="<?= lang('Dashboard.tags') ?>" data-tagin-placeholder="<?= lang('Dashboard.tags').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= old('tags') ?>">
                                                    <small class="text-info"><?= lang('Dashboard.separateWithAComma') ?></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.referenceTitle') ?></label>
                                                <input type="text" class="form-control" name="reference_title" id="reference_title" placeholder="<?= lang('Dashboard.exGoogle') ?>" value="<?= old('reference_title') ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.referenceUrl') ?></label>
                                                <input dir="ltr" type="url" class="form-control" name="reference_url" id="reference_url" placeholder="<?= lang('Dashboard.www.Google.com') ?>" value="<?= old('reference_url') ?>">
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-3">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.postSettings'); ?></h3>
                                <div class="card-tools">

                                </div>
                            </div>

                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-sm-12">

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.postStructure') ?> *</label>
                                                <select class="form-control select2bs4" name="structure_id" id="structure_id" required>
                                                    <?php
                                                    foreach ($blogStructure as $structure)
                                                    {
                                                        ?>
                                                        <option value="<?= $structure->id ?>"><?= $structure->title ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.fileUrl')." <small class='text-info'>(".lang('Dashboard.videoOrAudioContent').")</small>" ?></label>
                                                <input dir="ltr" type="url" class="form-control" name="url" id="url" placeholder="https://domain.com/video.mkv" value="<?= old('url') ?>">
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.category') ?> *</label>
                                                <select class="form-control select2bs4" name="category_id" id="category_id" required>
                                                    <option value="" disabled selected><?= lang('Dashboard.pleaseSelect') ?></option>
                                                    <?php
                                                    foreach ($blogMainCategories as $mainCategory)
                                                    {
                                                    ?>
                                                        <option value="<?= $mainCategory->id ?>">◼ <?= $mainCategory->title ?></option>
                                                        <?php
                                                        //To get sub category 1
                                                        $db = db_connect();
                                                        $builder = $db->table('categories_tbl');
                                                        $builder->where('locale', $locale);
                                                        $builder->where('status', 1);
                                                        $builder->where('parent_id', $mainCategory->id);
                                                        $builder->where('deleted_at', NULL);
                                                        $builder->where('type_id', 3);
                                                        $subCategory1 = $builder->get()->getResult();
                                                        foreach($subCategory1 as $sKey1)
                                                        {
                                                            echo "<option value='$sKey1->id'>&nbsp;&nbsp;&nbsp;&nbsp;◾&nbsp;$sKey1->title</option>";

                                                            //To get sub sub category 2
                                                            $builder->where('parent_id', $sKey1->id);
                                                            $builder->where('type_id', 3);
                                                            $builder->where('deleted_at', NULL);
                                                            $subSubCategory2 = $builder->get()->getResult();
                                                            foreach($subSubCategory2 as $ssKey2)
                                                            {
                                                                echo "<option value='$ssKey2->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◽&nbsp;$ssKey2->title</option>";

                                                                //To get sub sub sub category 3
                                                                $builder->where('parent_id', $ssKey2->id);
                                                                $builder->where('type_id', 3);
                                                                $builder->where('deleted_at', NULL);
                                                                $subSubCategory3 = $builder->get()->getResult();
                                                                foreach($subSubCategory3 as $sssKey3)
                                                                {
                                                                    echo "<option value='$sssKey3->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;$sssKey3->title</option>";

                                                                    //To get sub sub sub sub category 4
                                                                    $builder->where('parent_id', $sssKey3->id);
                                                                    $builder->where('type_id', 3);
                                                                    $builder->where('deleted_at', NULL);
                                                                    $subSubCategory4 = $builder->get()->getResult();
                                                                    foreach($subSubCategory4 as $ssssKey4)
                                                                    {
                                                                        echo "<option value='$ssssKey4->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;$ssssKey4->title</option>";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $db->close();
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label><?= lang('Dashboard.image') ?></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image">
                                                        <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                    </div>
                                                </div>
                                                <small class="text-info"><?= lang('Dashboard.theBestImageRatioShouldBe',[850, 350]) ?></small>
                                            </div>

                                            <br>
                                            <div class="form-group">
                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="special" type="checkbox"> <?= lang('Dashboard.specialPost') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="featured" type="checkbox"> <?= lang('Dashboard.featuredPost') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="is_advertising" type="checkbox"> <?= lang('Dashboard.isAdvertising') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="allow_comments" checked type="checkbox"> <?= lang('Dashboard.allowComments') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                                <div class="offset-sm-0 col-sm-12">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="status" type="checkbox"> <?= lang('Dashboard.publishThisPost') ?>
                                                        </label>
                                                    </div>
                                                </div>

                                            </div>

                                            <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeCreatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>

                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    <?php
                                    $session = session();
                                    $role_id = $session->role_id;
                                    if($role_id != 9 AND $role_id != 19)
                                    {
                                        ?>
                                        <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.addNewPost') ?>"><?= lang('Dashboard.addNewPost') ?></button>
                                        <?php
                                    }else{
                                        ?>
                                        <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.addNewPost') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <!-- /.card-footer-->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
            </form>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>