<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.advertising') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-7">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-tapsell-plus-configuration') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">

                                    <div class="form-group row">
                                        <label for="tapsell_website_script" class="col-sm-4 col-form-label"><?= lang('Dashboard.tapsellWebsiteScript') ?> *</label>
                                        <div class="col-sm-8">
                                            <textarea class="form-control" name="tapsell_website_script" rows="4" dir="ltr" placeholder="<script> ... </script>"><?= $tapsellPlus->tapsell_website_script ?></textarea>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="tapsell_website_script_status" class="col-sm-4 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-8">
                                        <?php
                                        $tapsell_website_script_status_checked = "";
                                        if($tapsellPlus->tapsell_website_script_status == 1)
                                            $tapsell_website_script_status_checked = "checked";
                                        ?>
                                        <input name="tapsell_website_script_status" type="checkbox" <?= $tapsell_website_script_status_checked ?>> <?= lang('Dashboard.websiteScriptStatus') ?>
                                        </div>
                                    </div>
                                    <hr>
                                
                                    <div class="form-group row">
                                        <label for="tapsell_key" class="col-sm-4 col-form-label"><?= lang('Dashboard.tapsellKey') ?> *</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" name="tapsell_key" value="<?= $tapsellPlus->tapsell_key ?>" placeholder="<?= lang('Dashboard.tapsellKey') ?>" required>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="tapsell_rewarded_video" class="col-sm-4 col-form-label"><?= lang('Dashboard.tapsellRewardedVideo') ?> *</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" name="tapsell_rewarded_video" value="<?= $tapsellPlus->tapsell_rewarded_video ?>" placeholder="<?= lang('Dashboard.tapsellRewardedVideo') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="tapsell_rewarded_video_status" class="col-sm-4 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-8">
                                        <?php
                                        $tapsell_rewarded_video_status_checked = "";
                                        if($tapsellPlus->tapsell_rewarded_video_status == 1)
                                            $tapsell_rewarded_video_status_checked = "checked";
                                        ?>
                                        <input name="tapsell_rewarded_video_status" type="checkbox" <?= $tapsell_rewarded_video_status_checked ?>> <?= lang('Dashboard.rewardedVideoStatus') ?>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="tapsell_interstitial_video" class="col-sm-4 col-form-label"><?= lang('Dashboard.tapsellInterstitialVideo') ?> *</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" name="tapsell_interstitial_video" value="<?= $tapsellPlus->tapsell_interstitial_video ?>" placeholder="<?= lang('Dashboard.tapsellInterstitialVideo') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="tapsell_interstitial_video_status" class="col-sm-4 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-8">
                                        <?php
                                        $tapsell_interstitial_video_status_checked = "";
                                        if($tapsellPlus->tapsell_interstitial_video_status == 1)
                                            $tapsell_interstitial_video_status_checked = "checked";
                                        ?>
                                        <input name="tapsell_interstitial_video_status" type="checkbox" <?= $tapsell_interstitial_video_status_checked ?>> <?= lang('Dashboard.tapsellInterstitialVideoStatus') ?>
                                        </div>
                                    </div>

                                    <hr>
                                    <div class="form-group row">
                                        <label for="tapsell_standard_banner" class="col-sm-4 col-form-label"><?= lang('Dashboard.tapsellStandardBanner') ?> *</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" name="tapsell_standard_banner" value="<?= $tapsellPlus->tapsell_standard_banner ?>" placeholder="<?= lang('Dashboard.tapsellStandardBanner') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="tapsell_standard_banner_status" class="col-sm-4 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-8">
                                        <?php
                                        $tapsell_standard_banner_status_checked = "";
                                        if($tapsellPlus->tapsell_standard_banner_status == 1)
                                            $tapsell_standard_banner_status_checked = "checked";
                                        ?>
                                        <input name="tapsell_standard_banner_status" type="checkbox" <?= $tapsell_standard_banner_status_checked ?>> <?= lang('Dashboard.tapsellStandardBannerStatus') ?>
                                        </div>
                                    </div>
                                    
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.tapsellAccount') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <p><?= lang('Dashboard.loginToYourTapsellAccountAndCreateAnAppAndGenerateYourTapsellKeyAndZoneId') ?> <a title="Tapsell Account" target="_blank" href="https://app.tapsell.ir/apps"><b><?= lang('Dashboard.clickHere') ?></b></a> !</p>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>