<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.advertising') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-7">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-admob-configuration') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                
                                    <div class="form-group row">
                                        <label for="application_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.applicationId') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="application_id" value="<?= $adMob->application_id ?>" placeholder="<?= lang('Dashboard.applicationId') ?>" required>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="banner_ad_unit_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.bannerAdUnitId') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="banner_ad_unit_id" value="<?= $adMob->banner_ad_unit_id ?>" placeholder="<?= lang('Dashboard.bannerAdUnitId') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="banner_ad_status" class="col-sm-3 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-9">
                                        <?php
                                        $banner_ad_status_checked = "";
                                        if($adMob->banner_ad_status == 1)
                                            $banner_ad_status_checked = "checked";
                                        ?>
                                        <input name="banner_ad_status" type="checkbox" <?= $banner_ad_status_checked ?>> <?= lang('Dashboard.bannerAdStatus') ?>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="interstitial_ad_unit_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.interstitialAdUnitId') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="interstitial_ad_unit_id" value="<?= $adMob->interstitial_ad_unit_id ?>" placeholder="<?= lang('Dashboard.interstitialAdUnitId') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="interstitial_ad_status" class="col-sm-3 col-form-label"><?= lang('Dashboard.active') ?></label>
                                        <div class="col-sm-9">
                                        <?php
                                        $interstitial_ad_status_checked = "";
                                        if($adMob->interstitial_ad_status == 1)
                                            $interstitial_ad_status_checked = "checked";
                                        ?>
                                        <input name="interstitial_ad_status" type="checkbox" <?= $interstitial_ad_status_checked ?>> <?= lang('Dashboard.interstitialAdStatus') ?>
                                        </div>
                                    </div>
                                    
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.adMobAccount') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <p><?= lang('Dashboard.loginToYourAdMobAccountAndCreateAnAppAndGenerateYourApplicationIdAndAdUnit') ?> <a title="AdMob Account" target="_blank" href="https://apps.admob.com"><b><?= lang('Dashboard.clickHere') ?></b></a> !</p>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>