<?= $this->extend('App\Views\auth\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('recaptcha') ?>
<?php 
if($captchaProtection->captcha_type == '2')
{
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v2_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v2 -->
    <script src="https://www.google.com/recaptcha/api.js?hl=<?= $theLocale ?>"></script>
<?php
} else if($captchaProtection->captcha_type == '3') {
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v3_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v3 -->
    <script src="https://www.google.com/recaptcha/api.js?render=<?= $site_key ?>"></script>
<?php
}
?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<?php
if($settingsData->registration == 0)
    die(lang('Dashboard.registrationHasBeenDisabled'));
?>
<body class="hold-transition register-page">
<div class="register-box">
    <div class="card card-outline card-primary">
        <div class="card-header text-center p-3">
            <a href="#" class="h2"><b><?= $settingsData->app_name ?></b></a>
        </div>
        <div class="card-body">
            <p class="login-box-msg"><?= lang('Dashboard.registerANewMembership') ?></p>
            <?= view('App\Views\backend\common\notifications_view'); ?>

            <form data-form-type="register" data-action="<?= base_url('auth/perform-register') ?>" <?php if($captcha_protection_website == '1') { ?> data-recaptcha-type="<?= $captcha_type ?>" data-recaptcha-key="<?= $site_key ?>" <?php } ?>>
                <?= csrf_field() ?>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" name="first_name" placeholder="<?= lang('Dashboard.firstName') ?>" value="<?= old('first_name') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-user"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" name="last_name" placeholder="<?= lang('Dashboard.lastName') ?>" value="<?= old('last_name') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-user"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="email" class="form-control" name="email" dir="ltr" placeholder="<?= lang('Dashboard.email') ?>" value="<?= old('email') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="password" class="form-control" name="password" dir="ltr" placeholder="<?= lang('Dashboard.password') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="password" class="form-control" name="password_confirm" dir="ltr" placeholder="<?= lang('Dashboard.retypePassword') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                <?php
                if($captcha_protection_website == '1' && $captcha_type == '2') {
                ?>
                    <!-- reCAPTCHA v2 widget -->
                    <div class="g-recaptcha pb-3" data-sitekey="<?= $site_key ?>"></div>
                <?php
                }
                ?>
                <div class="row">
                    <div class="col-7">
                        <div class="custom-control custom-checkbox" style="margin-top:5px;">
                            <input class="custom-control-input" type="checkbox" id="agreeTerms" name="terms" value="agree" required>
                            <label for="agreeTerms" class="custom-control-label"><a title="<?= lang('Dashboard.termsOfService') ?>" href="<?= $settingsData->terms_url ?>" target="_blank"><?= lang('Dashboard.termsOfService') ?></a></label>
                        </div>
                    </div>
                    <!-- /.col -->
                    <div class="col-5">
                        <button type="submit" id="submitButton" class="submitButton btn btn-primary btn-block" value="<?= lang('Dashboard.register') ?>"><?= lang('Dashboard.register') ?></button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>
            <br>
            <a href="<?= base_url('auth/login') ?>" class="text-center"><?= lang('Dashboard.iAlreadyHaveAMembership') ?></a>
        </div>
        <!-- /.form-box -->
    </div><!-- /.card -->
</div>
<!-- /.register-box -->
<?= $this->endSection() ?>

