<?= $this->extend('App\Views\auth\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('recaptcha') ?>
<?php 
if($captchaProtection->captcha_type == '2')
{
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v2_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v2 -->
    <script src="https://www.google.com/recaptcha/api.js?hl=<?= $theLocale ?>"></script> 
<?php
} else if($captchaProtection->captcha_type == '3') {
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v3_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v3 -->
    <script src="https://www.google.com/recaptcha/api.js?render=<?= $site_key ?>"></script>
<?php
}
?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
    <body class="hold-transition login-page">

    <div class="login-box">
        <!-- /.login-logo -->
		
        <div class="card card-outline card-primary">
            <div class="card-header text-center p-3">
                <a href="#" class="h2"><b><?= $settingsData->app_name ?></b></a>
            </div>

            <div class="card-body">
                <p class="login-box-msg"><?= lang('Dashboard.pleaseLoginToYourAccount') ?></p>
                <?= view('App\Views\backend\common\notifications_view'); ?>

                <form data-form-type="login" data-action="<?= base_url('auth/perform-login') ?>" <?php if($captcha_protection_website == '1') { ?> data-recaptcha-type="<?= $captcha_type ?>" data-recaptcha-key="<?= $site_key ?>" <?php } ?>>
                    <?= csrf_field() ?>
                    <div class="input-group mb-3">
                        <input type="email" id="email" name="email" dir="ltr" class="form-control" placeholder="<?= lang('Dashboard.email') ?>" value="<?= old('email') ?>" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" id="password" name="password" dir="ltr" class="form-control" placeholder="<?= lang('Dashboard.password') ?>" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                    </div>
                    <?php
                    if($captcha_protection_website == '1' && $captcha_type == '2') {
                    ?>
                        <!-- reCAPTCHA v2 widget -->
                        <div class="g-recaptcha pb-3" data-sitekey="<?= $site_key ?>"></div>
                    <?php
                    }
                    ?>
                    <div class="row">
                        <div class="col-7">
                            <div class="custom-control custom-checkbox" style="margin-top:5px;">
                                <input class="custom-control-input" type="checkbox" id="customCheckbox2" name="remember_me">
                                <label for="customCheckbox2" class="custom-control-label"><?= lang('Dashboard.rememberMe') ?></label>
                            </div>
                        </div>
                        <div class="col-5">
                            <button type="submit" id="submitButton" class="submitButton btn btn-primary btn-block" value="<?= lang('Dashboard.login') ?>"><?= lang('Dashboard.login') ?></button>
                        </div>
                        <!-- /.col -->
                    </div>
                </form>
                <br>
                <p class="mb-1"><a href="<?= base_url('auth/forgot-password') ?>"><?= lang('Dashboard.iForgotMyPassword') ?></a></p>
                <?php
                if($settingsData->registration == 1) {
                ?>
                <p class="mb-0"><a href="<?= base_url('auth/register') ?>" class="text-center"><?= lang('Dashboard.registerANewMembership') ?></a></p>
                <?php
                }
                ?>
            </div>
            <!-- /.card-body -->

        </div>
        <!-- /.card -->
    </div>
    <p class="mt-2"><?= lang('Dashboard.ciVer') ?> <?= CodeIgniter\CodeIgniter::CI_VERSION ?> — <?= lang('Dashboard.appVer') ?> <?= CodeIgniter\CodeIgniter::APP_VERSION ?></p>
    <!-- /.login-box -->

<?= $this->endSection() ?>

