<?= $this->extend('App\Views\auth\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('recaptcha') ?>
<?php 
if($captchaProtection->captcha_type == '2')
{
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v2_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v2 -->
    <script src="https://www.google.com/recaptcha/api.js?hl=<?= $theLocale ?>"></script> 
<?php
} else if($captchaProtection->captcha_type == '3') {
    $captcha_protection_website = $captchaProtection->captcha_protection_website;
    $site_key = $captchaProtection->recaptcha_v3_site_key;
    $captcha_type = $captchaProtection->captcha_type;
?>
    <!-- Google reCAPTCHA v3 -->
    <script src="https://www.google.com/recaptcha/api.js?render=<?= $site_key ?>"></script>
<?php
}
?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="card card-outline card-primary">
        <div class="card-header text-center p-3">
            <a href="#" class="h2"><b><?= $settingsData->app_name ?></b></a>
        </div>

        <div class="card-body">
            <p class="login-box-msg"><?= lang('Dashboard.youForgotYourPasswordHereYouCanEasilyRetrieveANewPassword') ?></p>
            <?= view('App\Views\backend\common\notifications_view'); ?>

            <form data-form-type="forgot_password" data-action="<?= base_url('auth/perform-forgot-password') ?>" <?php if($captcha_protection_website == '1') { ?> data-recaptcha-type="<?= $captcha_type ?>" data-recaptcha-key="<?= $site_key ?>" <?php } ?>>
                <?= csrf_field() ?>
                <div class="input-group mb-3">
                    <input type="email" name="email" id="email" dir="ltr" class="form-control" placeholder="<?= lang('Dashboard.email') ?>" value="<?= old('email') ?>" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <?php
                if($captcha_protection_website == '1' && $captcha_type == '2') {
                ?>
                    <!-- reCAPTCHA v2 widget -->
                    <div class="g-recaptcha pb-3" data-sitekey="<?= $site_key ?>"></div>
                <?php
                }
                ?>
                <div class="row">
                    <div class="col-12">
                        <button type="submit" id="submitButton" class="submitButton btn btn-primary btn-block" value="<?= lang('Dashboard.requestNewPassword') ?>"><?= lang('Dashboard.requestNewPassword') ?></button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>
            <p class="mt-3 mb-1">
                <a href="<?= base_url('auth/login') ?>"><?= lang('Dashboard.loginToAccount') ?></a>
            </p>
        </div>
        <!-- /.login-card-body -->
    </div>
</div>
<!-- /.login-box -->

<?= $this->endSection() ?>

