<?php

namespace App\Validation;
use App\Models\Backend\ApiModel;

class ApiRules
{
    public function validateApi(string $str, string $fields, array $data){
        $apiModel = new ApiModel();
        $api = $apiModel->where('id', $data['api_id'])->first();

        if(!$api)
            return false;

        $encrypter = \Config\Services::encrypter();
        $decoded_user_api_key = $encrypter->decrypt(base64_decode($api->api_key));

        if(($decoded_user_api_key != $data['api_key']) OR ($api->read != 1) OR ($api->status != 1))
            return false;
        else
            return true;
    }
}
