<?php

namespace App\Models\Backend;

use CodeIgniter\Model;

class BlogCommentModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'blog_comments_tbl';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = [
	    'user_id',
	    'post_id',
	    'reply_post_id',
	    'author_name',
	    'author_email',
	    'author_ip',
	    'author_agent',
	    'comment',
	    'like_count',
	    'dislike_count',
        'approved',
	    'created_at',
	    'updated_at',
	    'deleted_at',
    ];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
}
