<?php

namespace App\Models\Backend;

use CodeIgniter\Model;

class AdModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'ad_banners_tbl';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = false;
	protected $protectFields        = true;
	protected $allowedFields        = [
	    'user_id',
	    'ad_type_id',
	    'ad_place_id',
	    'title',
	    'description',
	    'image',
	    'url',
	    'how_to_open',
	    'clicked',
	    'viewed',
	    'responsive',
	    'ad_agency_title',
	    'ad_agency_url',
	    'ad_agency_image',
	    'active',
	    'expiration_time',
	    'created_at',
	    'updated_at',
	    'deleted_at',
    ];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
}
