<?php
use Config\Services;

if (! function_exists('sending_newsletter_email'))
{
    function sending_newsletter_email($settingsEmail, $allEmails, $subject, $message)
    {
        $smtp_pass_decode = base64_decode(strrev(base64_decode($settingsEmail->smtp_pass)));
        
        $recipients = explode(',', $allEmails); // Separate each email address
        $recipients = array_map('trim', $recipients); // Clean up any extra spaces around email addresses

        $htmlMessage = view('App\Views\email\header_view');
        $htmlMessage .= view('App\Views\email\newsletter_view', ['subject' => $subject, 'message' => $message]);
        $htmlMessage .= view('App\Views\email\footer_view');

        $email = \Config\Services::email();
        $email->initialize([
            'fromEmail' => $settingsEmail->no_reply_email,
            'fromName'  => $settingsEmail->from_name,
            'protocol'  => $settingsEmail->protocol,
            'SMTPHost'  => $settingsEmail->smtp_host,
            'SMTPUser'  => $settingsEmail->smtp_user,
            'SMTPPass'  => $smtp_pass_decode,
            'SMTPPort'  => intval($settingsEmail->smtp_port),
            'SMTPCrypto'=> $settingsEmail->smtp_crypto,
        ]);

        // Send the email to each recipient
        foreach ($recipients as $recipient) {
            $email->setTo($recipient);
            $email->setSubject($subject);
            $email->setMessage($htmlMessage);
            $email->send();
        }
        
        return;
    }
}


//===========================================================//
if (! function_exists('sending_mass_email'))
{
    function sending_mass_email($settingsEmail, $allEmails, $subject, $message)
    {
        $smtp_pass_decode = base64_decode(strrev(base64_decode($settingsEmail->smtp_pass)));
        
        $recipients = explode(',', $allEmails); // Separate each email address
        $recipients = array_map('trim', $recipients); // Clean up any extra spaces around email addresses

        $email = \Config\Services::email();
        $email->initialize([
            'fromEmail' => $settingsEmail->no_reply_email,
            'fromName'  => $settingsEmail->from_name,
            'protocol'  => $settingsEmail->protocol,
            'SMTPHost'  => $settingsEmail->smtp_host,
            'SMTPUser'  => $settingsEmail->smtp_user,
            'SMTPPass'  => $smtp_pass_decode,
            'SMTPPort'  => intval($settingsEmail->smtp_port),
            'SMTPCrypto'=> $settingsEmail->smtp_crypto,
        ]);

        // Send the email to each recipient
        foreach ($recipients as $recipient) {
            $rec = explode('|', $recipient);

            $htmlMessage = view('App\Views\email\header_view');
            $htmlMessage .= view('App\Views\email\mass_email_view', ['subject' => $subject, 'message' => $message, 'full_name' => $rec[1]]);
            $htmlMessage .= view('App\Views\email\footer_view');

            $email->setTo($rec[0]);
            $email->setSubject($subject);
            $email->setMessage($htmlMessage);
            $email->send();
        }
        
        return;
    }
}