<?php
use Config\Services;

if (! function_exists('number_to_fa'))
{
    /**
     * @param string  $number
     * @return string
     */
    function number_to_fa(string $number): string
    {
        $en_num = array('0','1','2','3','4','5','6','7','8','9');
        $fa_num = array('۰','۱','۲','۳','۴','۵','۶','۷','۸','۹');
        return str_replace($en_num, $fa_num, $number);
    }
}


if (! function_exists('number_to_en'))
{
    /**
     * @param string  $number
     * @return string
     */
    function number_to_en(string $input): string
    {
        /*$fa_num = array('۰','۱','۲','۳','۴','۵','۶','۷','۸','۹');
        $en_num = array('0','1','2','3','4','5','6','7','8','9');
        return str_replace($fa_num, $en_num, $number);*/

        // Persian and Arabic digits
        $persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabicDigits = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

        // English digits
        $englishDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

        // Replace Persian digits with English digits
        $output = str_replace($persianDigits, $englishDigits, $input);

        // Replace Arabic digits with English digits
        $output = str_replace($arabicDigits, $englishDigits, $output);

        return $output;
    }
}