<?php

namespace App\Filters;

use App\Models\Backend\RoleModel;
use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class Auth implements FilterInterface
{
	/**
	 * Do whatever processing this filter needs to do.
	 * By default it should not return anything during
	 * normal execution. However, when an abnormal state
	 * is found, it should return an instance of
	 * CodeIgniter\HTTP\Response. If it does, script
	 * execution will end and that Response will be
	 * sent back to the client, allowing for error pages,
	 * redirects, etc.
	 *
	 * @param RequestInterface $request
	 * @param array|null       $arguments
	 *
	 * @return mixed
	 */
	public function before(RequestInterface $request, $arguments = null)
	{
		if (!session()->get('isLoggedIn')) {
			return redirect()->to(base_url('auth/login'));
		}

		// Check permission
		if (session()->get('isLoggedIn')) {
			$role_id = session()->getTempdata('role_id');

			if ($role_id != 1) {
				$segment = service('uri')->getSegment(2);
				$roleModel = new RoleModel();
				$q = $roleModel->select('permission')
					->where('roles_tbl.id', $role_id)
					->first();
				$user_role_permission = $q->permission . ",logout";

				$user_permission_array = explode(',', $user_role_permission);
				$allow_access = array_search($segment, $user_permission_array);

				if (empty($allow_access)) {
					$response = service('response');
					if ($request->isAJAX()) { // If request from Ajax form (javascript)
						return $response->setJSON([
							'messageType' => 'sweetalert', // sweetalert OR toastr
							'messageIcon' => 'warning', // success , error , warning , info
							'messageTitle' => lang('Dashboard.warning'),
							'messageBody' => lang('Dashboard.youAreNotAllowedToAccessThisSection'),
						])->setStatusCode(400); // 200 OK
						
					} else { // If direct request to open URL
						return redirect()->back()->with('error', lang('Dashboard.youAreNotAllowedToAccessThisSection'));
					}
				}
			}

		}
	}

	/**
	 * Allows After filters to inspect and modify the response
	 * object as needed. This method does not allow any way
	 * to stop execution of other after filters, short of
	 * throwing an Exception or Error.
	 *
	 * @param RequestInterface  $request
	 * @param ResponseInterface $response
	 * @param array|null        $arguments
	 *
	 * @return mixed
	 */
	public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
	{
        //
	}
}
