<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\VersionModel;

class VersionController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
        $this->versionModel = new VersionModel();
    }


    //===========================================================//
	public function version_control()
	{
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'versions' => $this->versionModel
                    ->select('version_control_tbl.*')
                    ->orderBy('version_control_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->versionModel->pager
            ];

        }else{
            $data = [
                'versions' => $this->versionModel
                    ->select('version_control_tbl.*')
                    ->like('version_control_tbl.title', $keyword)
                    ->orderBy('version_control_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->versionModel->pager
            ];
        }

	    $data['pageTitle'] = lang('Dashboard.versionControl');
        $data['pageSubTitle'] = lang('Dashboard.versionsControlList');

        return view('\App\Views\backend\settings\version_control\versions_view', $data);
	}



    //===========================================================//
	public function add_version()
	{
	    $data['pageTitle'] = lang('Dashboard.addVersion');
        $data['pageSubTitle'] = lang('Dashboard.addVersion');

        return view('\App\Views\backend\settings\version_control\add_version_view', $data);
	}


    //===========================================================//
    public function perform_add_version()
    {
        // Validation the form
        $rules = [
            'title'                 => 'required|min_length[2]|max_length[50]',
            'version_code'          => 'required|integer|is_unique[version_control_tbl.version_code]',
            'version_name'          => 'required',
            'release_notes'         => 'required',
            'changelog'             => 'required',
            'upgrade_instructions'  => 'required',
            'download_url'          => 'required',
            'release_date'          => 'required',
            'upgrade_alarm'         => 'required',
            'status'                => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url('dashboard/add-version'))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $status = 0;
        if($this->request->getVar('status') == 'on') $status = 1;
        $data = [
            'title'                 => $this->request->getVar('title'),
            'version_code'          => $this->request->getVar('version_code'),
            'version_name'          => $this->request->getVar('version_name'),
            'release_notes'         => $this->request->getVar('release_notes'),
            'changelog'             => $this->request->getVar('changelog'),
            'upgrade_instructions'  => $this->request->getVar('upgrade_instructions'),
            'download_url'          => $this->request->getVar('download_url'),
            'release_date'          => $this->request->getVar('release_date'),
            'upgrade_alarm'         => $this->request->getVar('upgrade_alarm'),
            'status'                => $status,
        ];
        $this->versionModel->save($data);

        return redirect()->to(base_url("dashboard/version-control"))->with('success', lang('Dashboard.dataSuccessfullyCreated'));
    }


    //===========================================================//
	public function edit_version()
	{
        $version_id = service('uri')->getSegment(3);
        $data['version'] = $this->versionModel->select('version_control_tbl.*')->where('version_control_tbl.id', $version_id)->first();
        if(is_null($data['version']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));


	    $data['pageTitle'] = lang('Dashboard.editVersion');
        $data['pageSubTitle'] = lang('Dashboard.editVersion');

        return view('\App\Views\backend\settings\version_control\edit_version_view', $data);
	}


    //===========================================================//
    public function perform_edit_version()
    {
        $id = $this->request->getVar('id');
        // Validation the form
        $rules = [
            'id'                    => 'required|integer',
            'title'                 => 'required|min_length[2]|max_length[50]',
            'version_code'          => 'required|integer',
            'version_name'          => 'required',
            'release_notes'         => 'required',
            'changelog'             => 'required',
            'upgrade_instructions'  => 'required',
            'download_url'          => 'required',
            'release_date'          => 'required',
            'upgrade_alarm'         => 'required',
            'status'                => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/edit-version/$id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $status = 0;
        if($this->request->getVar('status') == "on") $status = 1;

        $data = [
            'id'                    => $this->request->getVar('id'),
            'title'                 => $this->request->getVar('title'),
            'version_code'          => $this->request->getVar('version_code'),
            'version_name'          => $this->request->getVar('version_name'),
            'release_notes'         => $this->request->getVar('release_notes'),
            'changelog'             => $this->request->getVar('changelog'),
            'upgrade_instructions'  => $this->request->getVar('upgrade_instructions'),
            'download_url'          => $this->request->getVar('download_url'),
            'release_date'          => $this->request->getVar('release_date'),
            'upgrade_alarm'         => $this->request->getVar('upgrade_alarm'),
            'status'                => $status,
        ];
        $this->versionModel->save($data);
        

        return redirect()->to(base_url("dashboard/version-control"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }


    //===========================================================//
    public function delete_version()
    {
        // Check version exist
        $version_id = service('uri')->getSegment(3);
        $version = $this->versionModel->where('id', $version_id)->first();
        if(is_null($version))
        {
            return redirect()->to(base_url('dashboard/version-control'))->with('error', lang('Dashboard.notFound'));

        }else{
            $this->versionModel->delete($version_id);

            return redirect()->to(base_url('dashboard/version-control'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }
}
