<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\TestimonialsModel;
use CodeIgniter\HTTP\ResponseInterface;

class TestimonialsController extends BaseController
{
    public function __construct()
    {
        $this->testimonialsModel = new TestimonialsModel();
        $this->session = session();
    }


    //===========================================================//
    public function add_testimonials()
    {
        $data['pageTitle'] = lang('Dashboard.addTestimonials');
        $data['pageSubTitle'] = lang('Dashboard.addTestimonials');
        return view('\App\Views\backend\testimonials\add_testimonials_view', $data);
    }


    //===========================================================//
    public function perform_add_testimonials()
    {
        $locale = $this->session->lang;

        // Validation the form
        $rules = [
            'full_name'         => 'required|min_length[2]|max_length[60]',
            'testimonials'      => 'required|min_length[10]|max_length[1000]',
            'stars'             => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,200]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'messageType'   => 'sweetalert', // sweetalert OR toastr
                'messageIcon'   => 'error', // success , error , warning , info
                'messageTitle'  => lang('Dashboard.error'),
                'errors'        => $this->validator->getErrors(),
                ])->setStatusCode(400); // 400 Bad Request
        }

        $newName = $newWebpName = "user_image.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $image_of_receipt = base_url()."backend/assets/uploads/admins/testimonials/$newWebpName";
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/testimonials/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 256;
            $imgHeight = 256;
            $imgWidthThumbnail = 0;
            $imgHeightThumbnail = 0;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }
        }

        $data = [
            'full_name'         => $this->request->getVar('full_name'),
            'testimonials'      => $this->request->getVar('testimonials'),
            'stars'             => $this->request->getVar('stars'),
            'locale'            => $locale,
            'image'             => $newWebpName,
        ];
        $this->testimonialsModel->save($data);

        return $this->response->setJSON([
            'messageType'   => 'sweetalert', // sweetalert OR toastr
            'messageIcon'   => 'success', // success , error , warning , info
            'messageTitle'  => lang('Dashboard.success'),
            'messageBody'   => lang('Dashboard.dataCreatedSuccessfully'),
            'newData'       => $data // newData OR updatedData
        ]);
    }


    //===========================================================//
    public function testimonials()
    {
        $locale = $this->session->lang;

        $data = [
            'testimonials' => $this->testimonialsModel
                ->select('testimonials_tbl.*')
                ->Where('testimonials_tbl.locale', $locale)
                ->orderBy('testimonials_tbl.id', 'DESC')
                ->paginate(10),
            'pager' => $this->testimonialsModel->pager
        ];

        $data['pageTitle'] = lang('Dashboard.usersTestimonials');
        $data['pageSubTitle'] = lang('Dashboard.usersTestimonials');
        return view('\App\Views\backend\testimonials\testimonials_view', $data);
    }


    //===========================================================//
    public function edit_testimonials()
    {
        $testimonials_id = service('uri')->getSegment(3);
        $locale = $this->session->lang;

        // Check exist or not
        $data['testimonials'] = $this->testimonialsModel->where('id', $testimonials_id)->first();
        if(is_null($data['testimonials']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));

        $data['pageTitle'] = lang('Dashboard.editTestimonials');
        $data['pageSubTitle'] = lang('Dashboard.editTestimonials');
        return view('\App\Views\backend\testimonials\edit_testimonials_view', $data);
    }


    //===========================================================//
    public function perform_edit_testimonials()
    {
        $id = $this->request->getVar('id');
        $old_image = $this->request->getVar('old_image');
        // Validation the form
        $rules = [
            'id'            => 'required|integer',
            'old_image'     => 'required',
            'full_name'     => 'required|min_length[2]|max_length[60]',
            'testimonials'  => 'required|min_length[10]|max_length[1000]',
            'stars'         => 'required',
            'image'         => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,200]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 500 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'messageType'   => 'sweetalert', // sweetalert OR toastr
                'messageIcon'   => 'error', // success , error , warning , info
                'messageTitle'  => lang('Dashboard.error'),
                'errors'        => $this->validator->getErrors(),
                ])->setStatusCode(400); // 400 Bad Request
        }

        $newName = $newWebpName = "user_image.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $image_of_receipt = base_url()."backend/assets/uploads/admins/testimonials/$newWebpName";
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/testimonials/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 256;
            $imgHeight = 256;
            $imgWidthThumbnail = 0;
            $imgHeightThumbnail = 0;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }

            // Remove old image from disk
            if($old_image != 'user_image.png') {
                @unlink($imgPath . $old_image);
            }

        }else {
            // No new image uploaded, keep the old one
            $newName = $newWebpName = $old_image;
        }

        $data = [
            'id'                => $this->request->getVar('id'),
            'full_name'         => $this->request->getVar('full_name'),
            'testimonials'      => $this->request->getVar('testimonials'),
            'stars'             => $this->request->getVar('stars'),
            'image'             => $newWebpName,
        ];
        $this->testimonialsModel->save($data);

        $msg = lang('Dashboard.dataSuccessfullyUpdated');
        $this->session->setFlashdata('success', $msg);

        return $this->response->setJSON([
            'redirectUrl'   => base_url('dashboard/testimonials'),
            'redirectTimer' => 0, // 3000 milliseconds = 3 seconds
            'messageType'   => 'sweetalert', // sweetalert OR toastr
            'messageIcon'   => 'success', // success , error , warning , info
            'messageTitle'  => lang('Dashboard.success'),
            'messageBody'   => lang('Dashboard.dataSuccessfullyUpdated'),
            'updatedData'   => $data // newData OR updatedData
        ]);

    }


    //===========================================================//
    public function delete_testimonials()
    {
        // Check exist
        $testimonials_id = service('uri')->getSegment(3);
        $testimonials = $this->testimonialsModel->where('id', $testimonials_id)->first();
        if(is_null($testimonials))
        {
            return redirect()->to(base_url('dashboard/testimonials'))->with('error', lang('Dashboard.notFound'));

        }else{
            // Delete
            $this->testimonialsModel->delete($testimonials_id);

            // Remove image from disk
            if($testimonials->image != 'user_image.png')
                @unlink('./backend/assets/uploads/admins/testimonials/'.$testimonials->image);

            return redirect()->to(base_url('dashboard/testimonials'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }
    
}
