<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\RoleModel;

class RoleController extends BaseController
{
    public function __construct()
    {
        $this->roleModel = new RoleModel();
        $this->session = session();
    }


    //===========================================================//
	public function user_roles()
	{
        $data = [
            'roles' => $this->roleModel
                ->select('roles_tbl.*')
                ->orderBy('roles_tbl.id', 'ASC')
                ->paginate(10),
            'pager' => $this->roleModel->pager
        ];

        $data['pageTitle'] = lang('Dashboard.userRoles');
        $data['pageSubTitle'] = lang('Dashboard.userRoles');
        return view('\App\Views\backend\users\user_roles_view', $data);
	}


    //===========================================================//
    public function edit_role()
    {
        $role_id = service('uri')->getSegment(3);
        $data['roleContent'] = $this->roleModel->where('id', $role_id)->first();
        if(is_null($data['roleContent']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));

        $data['pageTitle'] = lang('Dashboard.editUserRole');
        $data['pageSubTitle'] = lang('Dashboard.editUserRole');
        return view('\App\Views\backend\users\edit_role_view', $data);
    }


    //--------------------------------------------------------------------//
    public function perform_edit_role()
    {
        $id = $this->request->getVar('id');
        $active = 0;
        if($this->request->getPost('active') == "on")
            $active = 1;

        $rules = [
            'title'	                => 'required|min_length[2]',
            'permission'	        => 'required|min_length[4]',
            'active'	            => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/edit-role/$id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $data = [
            'id'  	        => $id,
            'title'  	    => $this->request->getVar('title'),
            'permission' 	=> $this->request->getVar('permission'),
            'active'     	=> $active,
        ];

        if (! $this->roleModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->roleModel->errors());
        }

        return redirect()->to(base_url('dashboard/user-roles'))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }
}
