<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\LanguageModel;
use App\Models\Backend\SettingModel;
use App\Models\Backend\HomeConfigurationModel;
use App\Models\Backend\CategoryModel;
use App\Models\Backend\PageModel;
use App\Models\Backend\BlogModel;

class LanguageController extends BaseController
{
    public function __construct()
    {
        $this->languageModel = new LanguageModel();
        $this->settingModel = new SettingModel();
        $this->homeConfigurationModel = new HomeConfigurationModel();
        $this->categoryModel = new CategoryModel();
        $this->pageModel = new PageModel();
        $this->blogModel = new BlogModel();
        $this->session = session();
    }


    //===========================================================//
	public function languages()
	{
        $data = [
            'languages' => $this->languageModel
                ->select('languages_tbl.*')
                ->orderBy('languages_tbl.id', 'ASC')
                ->paginate(10),
            'pager' => $this->languageModel->pager
        ];

	    $data['pageTitle'] = lang('Dashboard.languages');
        $data['pageSubTitle'] = lang('Dashboard.languages');

        return view('\App\Views\backend\settings\languages_view', $data);
	}



    //===========================================================//
    public function perform_create_language()
    {
        // Validation the form
        $rules = [
            'title'     => 'required|min_length[2]|max_length[40]',
            'locale'    => 'required|alpha_dash|min_length[2]|max_length[10]|is_unique[languages_tbl.locale]',
            'flag'      => 'required|min_length[2]|max_length[40]',
            'direction' => 'required|min_length[3]|max_length[3]',
            'status'    => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url('dashboard/languages'))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $status = 0;
        if($this->request->getVar('status') == 'on') $status = 1;
        $data = [
            'title'       => $this->request->getVar('title'),
            'locale'      => $this->request->getVar('locale'),
            'flag'        => $this->request->getVar('flag'),
            'direction'   => $this->request->getVar('direction'),
            'status'      => $status,
        ];
        $this->languageModel->save($data);

        // Insert data to settings_tbl
        $data = [
            'app_name'          => 'App Name',
            'locale'            => $this->request->getVar('locale'),
            'switch_language'   => 1,
        ];
        $this->settingModel->save($data);

        // Insert data to home_configuration_tbl
        $data = [
            'locale'            => $this->request->getVar('locale'),
        ];
        $this->homeConfigurationModel->save($data);

        return redirect()->to(base_url("dashboard/languages"))->with('success', lang('Dashboard.dataSuccessfullyCreated'));
    }


    //===========================================================//
    public function delete_language()
    {
        // Check language exist
        $language_id = service('uri')->getSegment(3);
        $language = $this->languageModel->where('id', $language_id)->first();
        if(is_null($language))
        {
            return redirect()->to(base_url('dashboard/languages'))->with('error', lang('Dashboard.notFound'));

        }else{
            // Prevent to delete current locale
            if($this->session->lang == $language->locale)
                return redirect()->to(base_url('dashboard/languages'))->with('error', lang('Dashboard.youCantDeleteCurrentLanguageFirstChangeYourLanguageToOther'));

            // Delete language + setting + category + page + blog + product + content with this locale
            $this->languageModel->delete($language_id);
            $this->settingModel->delete(['locale' => $language->locale]);
            $this->homeConfigurationModel->delete(['locale' => $language->locale]);
            //$this->categoryModel->where(['locale' => $language->locale])->delete();
            //$this->pageModel->where(['locale' => $language->locale])->delete();
            //$this->blogModel->where(['locale' => $language->locale])->delete();

            return redirect()->to(base_url('dashboard/languages'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }


    //===========================================================//
    public function update_language($id = NULL)
    {
        $id = service('uri')->getSegment(3);

        // Check the language is exist
        $data['language'] = $this->languageModel->select('languages_tbl.*')
            ->where('languages_tbl.id', $id)
            ->first();
        if(is_null($data['language']))
            return redirect()->to(base_url('dashboard/languages'))->with('error', lang('Dashboard.notFound'));


        $data['pageTitle'] = lang('Dashboard.updateLanguage');
        $data['pageSubTitle'] = lang('Dashboard.updateLanguage');

        return view('\App\Views\backend\settings\update_language_view', $data);
    }



    //===========================================================//
    public function perform_update_language()
    {
        $id = $this->request->getVar('id');
        // Validation the form
        $rules = [
            'id'        => 'required|integer',
            'title'     => 'required|min_length[2]|max_length[40]',
            'flag'      => 'required|min_length[2]|max_length[40]',
            'direction' => 'required|min_length[3]|max_length[3]',
            'status'    => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/update-language/$id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $status = 0;
        if($this->request->getVar('status') == 'on') $status = 1;
        $data = [
            'id'            => $this->request->getVar('id'),
            'title'         => $this->request->getVar('title'),
            'flag'          => $this->request->getVar('flag'),
            'direction'     => $this->request->getVar('direction'),
            'status'        => $status,
        ];
        $this->languageModel->save($data);

        return redirect()->to(base_url("dashboard/languages"))->with('success', lang('Dashboard.dataSuccessfullyCreated'));
    }
}
