<?php

namespace App\Controllers\Backend;
use App\Controllers\BaseController;
use App\Models\Backend\ActivityModel;
use App\Models\Backend\SettingModel;
use App\Models\Backend\SettingEmailModel;
use App\Models\Backend\UserModel;
use App\Models\Backend\WalletTransactionModel;
use Modules\Addons\Contents\Models\Backend\ContentDownloadedModel;

class DashboardController extends BaseController
{

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->settingModel = new SettingModel();
        $this->settingEmailModel = new SettingEmailModel();
        $this->walletTransactionModel = new WalletTransactionModel();
        $this->contentDownloadedModel = new ContentDownloadedModel();
        $this->session = session();
    }


    //===========================================================//
	public function home()
	{
        $id = $this->session->id;
        $role_id = $this->session->role_id;
        $this->activityModel = new ActivityModel();
        $db = db_connect();

        // Staff
        if($role_id <= 9)
        {
            $data = [
                'walletTransactions' => $this->walletTransactionModel
                    ->select('wallet_transactions_tbl.*, 
                        COALESCE(users_tbl.first_name, "' . lang('Dashboard.notRegistered') . '") AS first_name, 
                        COALESCE(users_tbl.last_name, "") AS last_name, 
                        COALESCE(payment_gateways_tbl.description, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_description,
                        COALESCE(payment_gateways_tbl.title, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_title')
                    ->join('users_tbl', 'users_tbl.id = wallet_transactions_tbl.user_id AND wallet_transactions_tbl.user_id != 0', 'left')
                    ->join('payment_gateways_tbl', 'payment_gateways_tbl.id = wallet_transactions_tbl.payment_gateway_id AND wallet_transactions_tbl.payment_gateway_id != 0', 'left')
                    ->orderBy('wallet_transactions_tbl.id', 'DESC')
                    ->limit(15)
                    ->get()->getResult(),
                
                'downloadedFiles' => $this->contentDownloadedModel
                    ->select('contents_downloaded_tbl.*, 
                        contents_tbl.title AS file_title, 
                        COALESCE(users_tbl.first_name, "' . lang('Dashboard.notRegistered') . '") AS first_name, 
                        COALESCE(users_tbl.last_name, "") AS last_name, 
                        COALESCE(users_tbl.email, "N/A") AS email, 
                        contents_tbl.title_slug AS file_title_slug, 
                        devices_types_tbl.title AS device_type_title')
                    ->join('users_tbl', 'users_tbl.id = contents_downloaded_tbl.user_id AND contents_downloaded_tbl.user_id != 0', 'left')
                    ->join('contents_tbl', 'contents_tbl.id = contents_downloaded_tbl.content_id')
                    ->join('devices_types_tbl', 'devices_types_tbl.id = contents_downloaded_tbl.device_type_id')
                    ->orderBy('contents_downloaded_tbl.id', 'DESC')
                    ->limit(15)
                    ->get()->getResult(),

                'activities' => $this->activityModel
                    ->select('activities_tbl.*,
                            COALESCE(users_tbl.first_name, "' . lang('Dashboard.system') . '") AS first_name, 
                            COALESCE(users_tbl.last_name, "") AS last_name')
                    ->join('users_tbl', 'users_tbl.id = activities_tbl.user_id AND activities_tbl.user_id != 0', 'left')
                    ->limit(15)
                    ->orderBy('activities_tbl.id', 'DESC')
                    ->get()->getResult()
            ];

            $startOfDay = strtotime('today midnight');
            $data['totalCreditAmountThisDay'] = $this->walletTransactionModel
                ->selectSum('amount')
                ->where('transaction_type', 'credit')
                ->where('transaction_tracking IS NOT NULL') // Successful transactions
                ->where('transaction_date >=', $startOfDay)
                ->get()
                ->getRow()
                ->amount;

            $startOfMonth = strtotime('first day of this month midnight');
            $data['totalCreditAmountThisMonth'] = $this->walletTransactionModel
                ->selectSum('amount')
                ->where('transaction_type', 'credit')
                ->where('transaction_tracking IS NOT NULL')
                ->where('transaction_date >=', $startOfMonth)
                ->get()
                ->getRow()
                ->amount;

            $startOfYear = strtotime('first day of January midnight');
            $data['totalCreditAmountThisYear'] = $this->walletTransactionModel
                ->selectSum('amount')
                ->where('transaction_type', 'credit')
                ->where('transaction_tracking IS NOT NULL')
                ->where('transaction_date >=', $startOfYear)
                ->get()
                ->getRow()
                ->amount;

            // Counts for successful and unsuccessful transactions
            $data['totalSuccessfulTransactionsThisDay'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NOT NULL')
                ->where('transaction_date >=', $startOfDay)
                ->countAllResults();

            $data['totalUnsuccessfulTransactionsThisDay'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NULL')
                ->where('transaction_date >=', $startOfDay)
                ->countAllResults();

            $data['totalSuccessfulTransactionsThisMonth'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NOT NULL')
                ->where('transaction_date >=', $startOfMonth)
                ->countAllResults();

            $data['totalUnsuccessfulTransactionsThisMonth'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NULL')
                ->where('transaction_date >=', $startOfMonth)
                ->countAllResults();

            $data['totalSuccessfulTransactionsThisYear'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NOT NULL')
                ->where('transaction_date >=', $startOfYear)
                ->countAllResults();

            $data['totalUnsuccessfulTransactionsThisYear'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NULL')
                ->where('transaction_date >=', $startOfYear)
                ->countAllResults();

            $data['totalSuccessfulTransactions'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NOT NULL')
                ->countAllResults();

            $data['totalUnsuccessfulTransactions'] = $this->walletTransactionModel
                ->where('transaction_tracking IS NULL')
                ->countAllResults();
    
            $data['totalCreditAmount'] = $this->walletTransactionModel->selectSum('amount')->where('transaction_type', 'credit')->where('transaction_tracking IS NOT NULL')->get()->getRow()->amount;

            $query = $db->table('users_tbl');
            $data['totalUsers'] = $query->where('deleted_at', null)->countAllResults();
            $data['userNote'] = $query->where('id', $this->session->id)->get()->getFirstRow();
            $data["registerDashboard"] = $query->where('device_type_id', 1)->countAllResults();
            $data["registerWebsite"] = $query->where('device_type_id', 2)->countAllResults();
            $data["registerMobile"] = $query->where('device_type_id', 3)->countAllResults();
            $data["registerAndroid"] = $query->where('device_type_id', 4)->countAllResults();
            $data["registerIos"] = $query->where('device_type_id', 5)->countAllResults();
            $data["registerInstallation"] = $query->where('device_type_id', 6)->countAllResults();

            $query = $db->table('categories_tbl');
            $data['totalCategories'] = $query->where('deleted_at', null)->where('locale', $this->session->lang)->countAllResults();

            $query = $db->table('blog_tbl');
            $data['totalPosts'] = $query->where('deleted_at', null)->where('locale', $this->session->lang)->countAllResults();

            $query = $db->table('contents_tbl');
            $data['totalFiles'] = $query->where('deleted_at', null)->where('locale', $this->session->lang)->countAllResults();

            $query = $db->table('ad_banners_tbl');
            $data['totalAdvertising'] = $query->where('deleted_at', null)->where('active', 1)->countAllResults();

            $query = $db->table('blog_comments_tbl');
            $data['totalPendingPostComments'] = $query->where('approved', 0)->where('deleted_at', null)->countAllResults();
            $data['totalApprovedPostComments'] = $query->where('approved', 1)->where('deleted_at', null)->countAllResults();
            $data['totalDeletedPostComments'] = $query->where('deleted_at !=', null)->countAllResults();

            $query = $db->table('contents_reviews_tbl');
            $data['totalPendingContentsReviews'] = $query->where('approved', 0)->where('deleted_at', null)->countAllResults();
            $data['totalApprovedContentsReviews'] = $query->where('approved', 1)->where('deleted_at', null)->countAllResults();
            $data['totalDeletedContentsReviews'] = $query->where('deleted_at !=', null)->countAllResults();
            
        // Users
        }else{
            $data['activities'] = $this->activityModel->select('activities_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                ->Where('activities_tbl.user_id', $id)
                ->join('users_tbl', 'users_tbl.id = activities_tbl.user_id')
                ->limit(15)
                ->orderBy('activities_tbl.id', 'DESC')
                ->get()->getResult();

            $query = $db->table('users_tbl');
            $data['userNote'] = $query->where('id', $this->session->id)->get()->getFirstRow();
        }

        $db->close();

        if($role_id <= 9) {
            $data['pageTitle'] = lang('Dashboard.dashboard');
            $data['pageSubTitle'] = lang('Dashboard.adminDashboard');
            return view('\App\Views\backend\dashboard_view', $data);

        } else {
            $data['pageTitle'] = lang('Dashboard.dashboard');
            $data['pageSubTitle'] = lang('Dashboard.userDashboard');
            return view('\App\Views\backend\dashboard_user_view', $data);
        }

	}


    //===========================================================//
    public function perform_edit_user_note()
    {
        $id = $this->session->id;

        $rules = [
            'user_note'	                => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'messageType' => 'errors',
                'errors' => $this->validator->getErrors(),
            ])->setStatusCode(400); // 400 Bad Request
        }

        $data = [
            'id'  	        => $id,
            'user_note'  	=> $this->request->getVar('user_note'),
        ];
        $this->userModel->save($data);

        return $this->response->setJSON([
            'messageType'       => 'sweetalert', // sweetalert OR toastr
            'messageIcon'       => 'success', // success , error , warning , info
            'messageTitle'      => lang('Dashboard.success'),
            'messageBody'       => lang('Dashboard.dataSuccessfullyUpdated'),
            'updatedData'           => $data // newData OR updatedData
        ])->setStatusCode(200); // 200 OK
    }


    //===========================================================//
	public function sending_push_notification_from_onesignal()
    {
        $data['pageTitle'] = lang('Dashboard.oneSignal');
        $data['pageSubTitle'] = lang('Dashboard.sendingPushNotificationToSubscribedUsers');
        return view('\App\Views\backend\push_notification\sending_push_notification_from_onesignal_view', $data);
    }


    //===========================================================//
	public function perform_sending_push_notification_from_onesignal()
    {
        $rules = [
            'title'         => 'required|min_length[2]',
            'message'       => 'required|min_length[2]',
            'locale'        => 'required',
            'url'           => 'permit_empty',
            'image'         => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,600]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 400 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/sending-push-notification-from-onesignal"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $title = $this->request->getVar('title');
        $message = $this->request->getVar('message');
        $locale = $this->request->getVar('locale');
        $url = $this->request->getVar('url');
        $app_url = $url; /* For application */
        $web_url = $url; /* For web browser */
        $big_picture = null;
        $settingsData = $this->settingModel->select('settings_tbl.onesignal_app_id, settings_tbl.onesignal_rest_api_key, settings_tbl.light_ic_launcher, settings_tbl.dark_ic_launcher')->where('settings_tbl.locale', $locale)->first();
        $small_icon = base_url("/backend/assets/uploads/admins/images/$settingsData->light_ic_launcher");
        $large_icon = base_url("/backend/assets/uploads/admins/images/$settingsData->light_ic_launcher");

        $newName = "push.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/push_notifications/', $newName);

            $imgPath = $img->getTempName();
            $imgQuality = 90;
            $watermark = "";
            $image = \Config\Services::image()
                ->withFile($imgPath.$newName)
                ->text($watermark, [
                    'color'      => '#f9f9f9',
                    'opacity'    => 0.7,
                    'withShadow' => false,
                    'hAlign'     => 'center', /* hAlign Horizontal alignment: left, center, right */
                    'vAlign'     => 'middle', /* vAlign Vertical alignment: top, middle, bottom */
                    'fontSize'   => 25,
                    'fontPath'   => ''
                ])
                ->fit(500, 250, 'center')
                ->save('./backend/assets/uploads/admins/push_notifications/'.$newName, $imgQuality);
            
            $big_picture = base_url("/backend/assets/uploads/admins/push_notifications/$newName");
        }

        helper('onesignal_helper');
        $response = sending_push_notification_from_onesignal($settingsData->onesignal_app_id, $settingsData->onesignal_rest_api_key, $title, $message, $small_icon, $large_icon, $big_picture, $app_url, $web_url, $locale);
        //print_r($response);
        //die();

        if (isset($response['error'])) {
            $this->session->setFlashdata('error', $response['message']);
        } else {
            $this->session->setFlashdata('success', lang('Dashboard.pushNotificationSentSuccessfully'));
        }
                
        return redirect()->to(base_url('dashboard/sending-push-notification-from-onesignal'));
    }


    //===========================================================//
	public function sending_newsletter()
    {
        $data['pageTitle'] = lang('Dashboard.sendingNewsletter');
        $data['pageSubTitle'] = lang('Dashboard.sendingNewsletter');

        return view('\App\Views\backend\mass_email\sending_newsletter_view', $data);
    }


    //===========================================================//
	public function perform_sending_newsletter()
    {
        $this->settingEmailModel = new SettingEmailModel();

        $rules = [
            'subject'       => 'required|min_length[2]',
            'message'       => 'required|min_length[2]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/sending-newsletter"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $subject = $this->request->getVar('subject');
        $message = $this->request->getVar('message');

        // Sending mass email
        $settingsEmail = $this->settingEmailModel->select('settings_email_tbl.*')->where('settings_email_tbl.id', 1)->first();

        // Get all emails from newsletter table
        $db = db_connect();
        $builder = $db->table('newsletter_tbl');
        $Recipients = @$builder->get()->getResult();
        
        if (!empty($Recipients)) {
            $emailList = []; // Initialize an empty array to store email addresses
        
            foreach ($Recipients as $recipient) {
                $emailList[] = $recipient->email; // Add each email address to the array
            }
        
            // Join the email addresses using commas
            $allEmails = implode(',', $emailList);
            $totalEmails = count($emailList);
        }
        $db->close();

        helper('mass_email');
        @sending_newsletter_email($settingsEmail, $allEmails, $subject, $message);
        
        $this->session->setFlashdata('success', lang('Dashboard.massEmailSentSuccessfullyToXEmails', [$totalEmails]));
        return redirect()->to(base_url('dashboard/sending-newsletter'));
    }


    //===========================================================//
	public function sending_email()
    {
        $db = db_connect();

        // Fetch user roles
        $builder = $db->table('roles_tbl');
        $builder->where('active', 1);
        $builder->orderBy('id', 'ASC');
        $data['roles'] = $builder->get()->getResult();

        // Fetch user statuses
        $builder = $db->table('user_statuses_tbl');
        $builder->orderBy('id', 'ASC');
        $data['statuses'] = $builder->get()->getResult();

        // Fetch user devices
        $builder = $db->table('devices_types_tbl');
        $builder->orderBy('id', 'ASC');
        $data['devices'] = $builder->get()->getResult();

        $db->close();

        $data['pageTitle'] = lang('Dashboard.sendingEmail');
        $data['pageSubTitle'] = lang('Dashboard.sendingEmail');

        return view('\App\Views\backend\mass_email\sending_email_view', $data);
    }


    //===========================================================//
	public function perform_sending_email()
    {
        $this->settingEmailModel = new SettingEmailModel();

        $rules = [
            'subject'           => 'required|min_length[2]',
            'message'           => 'required|min_length[2]',
            'role_id'           => 'required',
            'status_id'         => 'required',
            'device_type_id'    => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/sending-newsletter"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $subject = $this->request->getVar('subject');
        $message = $this->request->getVar('message');
        $role_id = $this->request->getVar('role_id');
        $status_id = $this->request->getVar('status_id');
        $device_type_id = $this->request->getVar('device_type_id');

        // Sending mass email
        $settingsEmail = $this->settingEmailModel->select('settings_email_tbl.*')->where('settings_email_tbl.id', 1)->first();

        // Get all emails from users table
        $Recipients = $this->userModel
            ->select('users_tbl.email, users_tbl.first_name, users_tbl.last_name')
            ->where('users_tbl.deleted_at', NULL)
            ->where('users_tbl.role_id', $role_id)
            ->where('users_tbl.status_id', $status_id)
            ->where('users_tbl.device_type_id', $device_type_id)
            ->get()->getResult();

        if (!empty($Recipients)) {
            $emailList = []; // Initialize an empty array to store email addresses
        
            foreach ($Recipients as $recipient) {
                $emailList[] = $recipient->email.'|'.$recipient->first_name.' '.$recipient->last_name; // Add each email address to the array
            }
        
            // Join the email addresses using commas
            $allEmails = implode(',', $emailList);
            $totalEmails = count($emailList);

        }

        helper('mass_email');
        @sending_mass_email($settingsEmail, $allEmails, $subject, $message);
        
        if(empty($totalEmails))
            $this->session->setFlashdata('warning', lang('Dashboard.noEmailWasSentChooseAnotherFilter'));
        else
            $this->session->setFlashdata('success', lang('Dashboard.massEmailSentSuccessfullyToXEmails', [$totalEmails]));
        return redirect()->to(base_url('dashboard/sending-email'));
    }


    //===========================================================//
	public function offline_payment()
    {
        $user_id = $this->request->getGet('user_id');
        $wallet_id = $this->request->getGet('wallet_id');
        $order_id = $this->request->getGet('order_id');
        $amount = $this->request->getGet('amount');
        $description = $this->request->getGet('description');
        $transaction_date = $this->request->getGet('transaction_date');

        //var_dump($user_id, $wallet_id, $order_id, $amount, $description, $transaction_date);

        $data['pageTitle'] = lang('Dashboard.offlinePayment');
        $data['pageSubTitle'] = lang('Dashboard.bankReceiptSubmission');

        return view('\App\Views\backend\users\offline_payment_view', $data);
    }


    //===========================================================//
	public function perform_offline_payment()
    {
        $user_id = $this->session->id;

        $rules = [
            'amount'                => 'required|numeric|greater_than_equal_to[20000]|less_than_equal_to[30000000]|regex_match[/^\d+(\.\d{1,2})?$/]',
            'transaction_date'      => 'required',
            'transaction_tracking'  => 'required',
            'description'           => 'required',
            'wallet_id'             => 'required',
            'currency_decimals'     => 'required',
            'currency_suffix'       => 'required',
            'image'                 => [
                                        'ext_in[image,png,jpg,jpeg]',
                                        'is_image[image]',
                                        'max_size[image,1024]',
                                        'errors' => [
                                            'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]),
                                            'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                                        ]
                                    ],
                                ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'messageType'   => 'sweetalert', // sweetalert OR toastr
                'messageIcon'   => 'error', // success , error , warning , info
                'messageTitle'  => lang('Dashboard.error'),
                'errors'        => $this->validator->getErrors(),
                ])->setStatusCode(400); // 400 Bad Request
        }

        $newName = $newWebpName = "receipt.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $image_of_receipt = base_url()."backend/assets/uploads/admins/bank_receipt/$newWebpName";
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/bank_receipt/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 600;
            $imgHeight = 600;
            $imgWidthThumbnail = 0;
            $imgHeightThumbnail = 0;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }
        }

        $user = $this->userModel->find($user_id);

        $settings = $this->settingModel->select('settings_tbl.email_address, settings_tbl.app_name')->where('settings_tbl.locale', $this->session->lang)->first();
        $to = $settings->email_address;
        $app_name = $settings->app_name;

        $amount = $this->request->getVar('amount');
        $wallet_id = $this->request->getVar('wallet_id');
        $currency_decimals = $this->request->getVar('currency_decimals');
        $currency_suffix = $this->request->getVar('currency_suffix');
        $transaction_date = $this->request->getVar('transaction_date');
        $transaction_tracking = $this->request->getVar('transaction_tracking');
        $description = $this->request->getVar('description');
        $subject = $app_name . " - " .lang('Dashboard.bankReceiptSubmission');

        // Sending email
        $settingsEmail = $this->settingEmailModel->select('settings_email_tbl.*')->where('settings_email_tbl.id', 1)->first();

        helper('email');
        $new_amount = number_format($amount, $currency_decimals, '.', ',') .' '. $currency_suffix;
        @offline_payment_email($settingsEmail, $subject, $to, $user_id, $user->first_name, $user->last_name, $user->email, $new_amount, $transaction_date, $transaction_tracking, $description, $image_of_receipt);

        // Activity
        $this->activityModel = new ActivityModel();
        $activity = [
            'user_id'       => $user_id,
            'icon'          => 'fas fa-receipt',
            'background'    => 'bg-teal',
            'title'         => lang('Dashboard.payment'),
            'body'          => lang('Dashboard.theReceiptOfPaymentInTheAmountOfXHasBeenSent', [number_format($amount, $currency_decimals, '.', ',') .' '. $currency_suffix]),
            'ip'            => $_SERVER['REMOTE_ADDR'],
            'agent'         => $_SERVER['HTTP_USER_AGENT'],
            'time'          => time(),
        ];
        $this->activityModel->save($activity);

        return $this->response->setJSON([
            'messageType' => 'sweetalert', // sweetalert OR toastr
            'messageIcon' => 'success', // success , error , warning , info
            'messageTitle' => lang('Dashboard.success'),
            'messageBody' => lang('Dashboard.yourPaymentReceiptHasBeenSentSuccessfullyAfterVerificationByTheFinancialUnitYourPaymentWillBeConfirmed')
        ]);
    }

}
