<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\AdModel;
use App\Models\Backend\AdMobConfigurationModel;
use App\Models\Backend\TapsellPlusConfigurationModel;

class AdController extends BaseController
{
    public function __construct()
    {
        $this->adModel = new AdModel();
        $this->session = session();
    }

    //===========================================================//
    public function create_new_ad()
    {
        $db = db_connect();

        // Fetch ad type
        $builder = $db->table('ad_banners_types_tbl');
        $builder->where('active', 1);
        $builder->orderBy('id', 'ASC');
        $data['adTypes'] = $builder->get()->getResult();

        // Fetch ad place
        $builder = $db->table('custom_codes_place_tbl');
        $builder->where('active', 1);
        $builder->where('id >', 4);
        $builder->orderBy('id', 'ASC');
        $data['adPlaces'] = $builder->get()->getResult();

        $db->close();

        $data['pageTitle'] = lang('Dashboard.createNewAd');
        $data['pageSubTitle'] = lang('Dashboard.createNewAd');
        return view('\App\Views\backend\advertising\create_new_ad_view', $data);
    }


    //===========================================================//
    public function perform_create_new_ad()
    {
        // Validation the form
        $rules = [
            'user_id'           => 'required|integer',
            'ad_type_id'        => 'required|integer',
            'ad_place_id'       => 'required|integer',
            'title'             => 'required|min_length[2]|max_length[100]',
            'description'       => 'permit_empty|max_length[255]',
            'url'               => 'required|min_length[8]|max_length[255]',
            'how_to_open'       => 'required',
            'ad_agency_title'   => 'permit_empty|max_length[100]',
            'ad_agency_url'     => 'permit_empty|max_length[100]',
            'responsive'        => 'permit_empty',
            'active'            => 'permit_empty',
            'image'             => [
                'ext_in[image,png,jpg,jpeg,gif]',
                'is_image[image]',
                'max_size[image,600]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 600 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegGifExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/create-new-ad"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $fit_width = 300;
        $fit_height = 250;

        $ad_type_id = $this->request->getVar('ad_type_id');
        if($ad_type_id == 1) {
            $fit_width = 250;
            $fit_height = 250;
        }
        if($ad_type_id == 2) {
            $fit_width = 160;
            $fit_height = 600;
        }
        if($ad_type_id == 3) {
            $fit_width = 300;
            $fit_height = 250;
        }
        if($ad_type_id == 4) {
            $fit_width = 300;
            $fit_height = 600;
        }
        if($ad_type_id == 5) {
            $fit_width = 320;
            $fit_height = 50;
        }
        if($ad_type_id == 6) {
            $fit_width = 320;
            $fit_height = 100;
        }
        if($ad_type_id == 7) {
            $fit_width = 336;
            $fit_height = 280;
        }
        if($ad_type_id == 8) {
            $fit_width = 468;
            $fit_height = 60;
        }
        if($ad_type_id == 9) {
            $fit_width = 728;
            $fit_height = 90;
        }
        if($ad_type_id == 10) {
            $fit_width = 970;
            $fit_height = 250;
        }

        $newName = "ad_banner.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/advertising/', $newName);

            $imgPath = $img->getTempName();
            $imgQuality = 100;
            $watermark = "";
            $image = \Config\Services::image()
                ->withFile($imgPath.$newName)
                ->text($watermark, [
                    'color'      => '#f9f9f9',
                    'opacity'    => 0.7,
                    'withShadow' => false,
                    'hAlign'     => 'center', /* hAlign Horizontal alignment: left, center, right */
                    'vAlign'     => 'middle', /* vAlign Vertical alignment: top, middle, bottom */
                    'fontSize'   => 25,
                    'fontPath'   => ''
                ])
                ->fit($fit_width, $fit_height, 'center')
                ->save('./backend/assets/uploads/admins/advertising/'.$newName, $imgQuality);
        }

        $responsive = $active = 0;
        if($this->request->getVar('responsive') == "on") $responsive = 1;
        if($this->request->getVar('active') == "on") $active = 1;

        $adData = [
            'user_id'           => $this->request->getVar('user_id'),
            'ad_type_id'        => $this->request->getVar('ad_type_id'),
            'ad_place_id'       => $this->request->getVar('ad_place_id'),
            'title'             => $this->request->getVar('title'),
            'description'       => $this->request->getVar('description'),
            'url'               => $this->request->getVar('url'),
            'how_to_open'       => $this->request->getVar('how_to_open'),
            'ad_agency_title'   => $this->request->getVar('ad_agency_title'),
            'ad_agency_url'     => $this->request->getVar('ad_agency_url'),
            'image'             => $newName,
            'responsive'        => $responsive,
            'expiration_time'   => 0,
            'active'            => $active,
        ];
        $this->adModel->save($adData);

        return redirect()->to(base_url("dashboard/create-new-ad"))->with('success', lang('Dashboard.dataCreatedSuccessfully'));
    }


    //===========================================================//
    public function advertising_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'advertising' => $this->adModel
                    ->select('ad_banners_tbl.*, ad_banners_types_tbl.title AS ad_type_title, custom_codes_place_tbl.title AS ad_place_title')
                    ->Where('ad_banners_tbl.deleted_at', NULL) // To prevent show softDeleted row
                    ->join('ad_banners_types_tbl', 'ad_banners_types_tbl.id = ad_banners_tbl.ad_type_id')
                    ->join('custom_codes_place_tbl', 'custom_codes_place_tbl.id = ad_banners_tbl.ad_place_id')
                    ->orderBy('ad_banners_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->adModel->pager
            ];

        }else{
            $data = [
                'advertising' => $this->adModel
                ->select('ad_banners_tbl.*, ad_banners_types_tbl.title AS ad_type_title, custom_codes_place_tbl.title AS ad_place_title')
                ->like('ad_banners_tbl.title',$keyword)
                ->orLike('ad_banners_tbl.url',$keyword)
                ->join('ad_banners_types_tbl', 'ad_banners_types_tbl.id = ad_banners_tbl.ad_type_id')
                ->join('custom_codes_place_tbl', 'custom_codes_place_tbl.id = ad_banners_tbl.ad_place_id')
                ->orderBy('ad_banners_tbl.id', 'DESC')
                ->paginate(10),
                'pager' => $this->adModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.advertisingList');
        $data['pageSubTitle'] = lang('Dashboard.internalAdvertisingList');
        return view('\App\Views\backend\advertising\advertising_list_view', $data);
    }


    //===========================================================//
    public function edit_ad()
    {
        $ad_id = service('uri')->getSegment(3);

        // Check ad exist or not
        $data['ad'] = $this->adModel->where('id', $ad_id)->first();
        if(is_null($data['ad']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));

        $db = db_connect();

        // Fetch ad type
        $builder = $db->table('ad_banners_types_tbl');
        $builder->where('active', 1);
        $builder->orderBy('id', 'ASC');
        $data['adTypes'] = $builder->get()->getResult();

        // Fetch ad place
        $builder = $db->table('custom_codes_place_tbl');
        $builder->where('active', 1);
        $builder->where('id >', 4);
        $builder->orderBy('id', 'ASC');
        $data['adPlaces'] = $builder->get()->getResult();

        $db->close();

        $data['adContent'] = $this->adModel->select('ad_banners_tbl.*')
            ->where('ad_banners_tbl.id', $ad_id)
            ->first();

        $data['pageTitle'] = lang('Dashboard.editAd');
        $data['pageSubTitle'] = lang('Dashboard.editAd');
        return view('\App\Views\backend\advertising\edit_ad_view', $data);
    }


    //===========================================================//
    public function perform_edit_ad()
    {
        $id = $this->request->getVar('id');
        $user_id = $this->request->getVar('user_id');
        $old_image = $this->request->getVar('old_image');
        // Validation the form
        $rules = [
            'id'                => 'required|integer',
            'user_id'           => 'required|integer',
            'ad_type_id'        => 'required|integer',
            'ad_place_id'       => 'required|integer',
            'title'             => 'required|min_length[2]|max_length[100]',
            'description'       => 'permit_empty|max_length[255]',
            'url'               => 'required|min_length[8]|max_length[255]',
            'how_to_open'       => 'required',
            'ad_agency_title'   => 'permit_empty|max_length[100]',
            'ad_agency_url'     => 'permit_empty|max_length[100]',
            'responsive'        => 'permit_empty',
            'active'            => 'permit_empty',
            'old_image'         => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg,gif]',
                'is_image[image]',
                'max_size[image,600]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 600 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegGifExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/edit-ad/$id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $fit_width = 300;
        $fit_height = 250;

        $ad_type_id = $this->request->getVar('ad_type_id');
        if($ad_type_id == 1) {
            $fit_width = 250;
            $fit_height = 250;
        }
        if($ad_type_id == 2) {
            $fit_width = 160;
            $fit_height = 600;
        }
        if($ad_type_id == 3) {
            $fit_width = 300;
            $fit_height = 250;
        }
        if($ad_type_id == 4) {
            $fit_width = 300;
            $fit_height = 600;
        }
        if($ad_type_id == 5) {
            $fit_width = 320;
            $fit_height = 50;
        }
        if($ad_type_id == 6) {
            $fit_width = 320;
            $fit_height = 100;
        }
        if($ad_type_id == 7) {
            $fit_width = 336;
            $fit_height = 280;
        }
        if($ad_type_id == 8) {
            $fit_width = 468;
            $fit_height = 60;
        }
        if($ad_type_id == 9) {
            $fit_width = 728;
            $fit_height = 90;
        }
        if($ad_type_id == 10) {
            $fit_width = 970;
            $fit_height = 250;
        }

        $newName = "ad_banner.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/advertising/', $newName);

            $imgPath = $img->getTempName();
            $imgQuality = 100;
            $watermark = "";
            $image = \Config\Services::image()
                ->withFile($imgPath.$newName)
                ->text($watermark, [
                    'color'      => '#f9f9f9',
                    'opacity'    => 0.7,
                    'withShadow' => false,
                    'hAlign'     => 'center', /* hAlign Horizontal alignment: left, center, right */
                    'vAlign'     => 'middle', /* vAlign Vertical alignment: top, middle, bottom */
                    'fontSize'   => 25,
                    'fontPath'   => ''
                ])
                ->fit($fit_width, $fit_height, 'center')
                ->save('./backend/assets/uploads/admins/advertising/'.$newName, $imgQuality);
        }


        $responsive = $active = 0;
        if($this->request->getVar('responsive') == "on") $responsive = 1;
        if($this->request->getVar('active') == "on") $active = 1;

        if($img != "")
        {
            // Update ad with image and delete old image
            $adData = [
                'id'                => $this->request->getVar('id'),
                'user_id'           => $this->request->getVar('user_id'),
                'ad_type_id'        => $this->request->getVar('ad_type_id'),
                'ad_place_id'       => $this->request->getVar('ad_place_id'),
                'title'             => $this->request->getVar('title'),
                'description'       => $this->request->getVar('description'),
                'url'               => $this->request->getVar('url'),
                'how_to_open'       => $this->request->getVar('how_to_open'),
                'ad_agency_title'   => $this->request->getVar('ad_agency_title'),
                'ad_agency_url'     => $this->request->getVar('ad_agency_url'),
                'image'             => $newName,
                'responsive'        => $responsive,
                'expiration_time'   => 0,
                'active'            => $active,
            ];
            $this->adModel->save($adData);

            // Remove old image from disk
            if($old_image != 'ad_banner.png')
                @unlink('./backend/assets/uploads/admins/advertising/'.$old_image);

        }else{
            // Update ad without image
            $adData = [
                'id'                => $this->request->getVar('id'),
                'user_id'           => $this->request->getVar('user_id'),
                'ad_type_id'        => $this->request->getVar('ad_type_id'),
                'ad_place_id'       => $this->request->getVar('ad_place_id'),
                'title'             => $this->request->getVar('title'),
                'description'       => $this->request->getVar('description'),
                'url'               => $this->request->getVar('url'),
                'how_to_open'       => $this->request->getVar('how_to_open'),
                'ad_agency_title'   => $this->request->getVar('ad_agency_title'),
                'ad_agency_url'     => $this->request->getVar('ad_agency_url'),
                'responsive'        => $responsive,
                'expiration_time'   => 0,
                'active'            => $active,
            ];
            $this->adModel->save($adData);
        }

        return redirect()->to(base_url("dashboard/advertising-list"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }


    //===========================================================//
    public function delete_ad()
    {
        // Check ad exist
        $ad_id = service('uri')->getSegment(3);
        $ad = $this->adModel->where('id', $ad_id)->first();
        if(is_null($ad))
        {
            return redirect()->to(base_url('dashboard/advertising-list'))->with('error', lang('Dashboard.notFound'));

        }else{
            // Delete ad
            $this->adModel->delete($ad_id);

            // Remove image from disk
            if($ad->image != 'ad_banner.png')
                @unlink('./backend/assets/uploads/admins/advertising/'.$ad->image);

            return redirect()->to(base_url('dashboard/advertising-list'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }


    //===========================================================//
    public function admob_configuration()
    {
        $this->adMobConfigurationModel = new AdMobConfigurationModel();

        $data['adMob'] = $this->adMobConfigurationModel->select('admob_configuration_tbl.*')
            ->where('admob_configuration_tbl.id', 1)
            ->first();

        $data['pageTitle'] = lang('Dashboard.adMobConfiguration');
        $data['pageSubTitle'] = lang('Dashboard.adMobConfiguration');
        return view('\App\Views\backend\advertising\admob_configuration_view', $data);
    }


    //===========================================================//
    public function perform_edit_admob_configuration()
    {
        // Validation the form
        $rules = [
            'application_id'            => 'required|max_length[255]',
            'banner_ad_unit_id'         => 'required|max_length[255]',
            'banner_ad_status'          => 'permit_empty',
            'interstitial_ad_unit_id'   => 'required|max_length[255]',
            'interstitial_ad_status'    => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/admob-configuration"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $this->adMobConfigurationModel = new AdMobConfigurationModel();

        $banner_ad_status = $interstitial_ad_status = 0;
        if($this->request->getVar('banner_ad_status') == "on") $banner_ad_status = 1;
        if($this->request->getVar('interstitial_ad_status') == "on") $interstitial_ad_status = 1;

        $data = [
            'id'                        => 1,
            'application_id'            => $this->request->getVar('application_id'),
            'banner_ad_unit_id'         => $this->request->getVar('banner_ad_unit_id'),
            'banner_ad_status'          => $banner_ad_status,
            'interstitial_ad_unit_id'   => $this->request->getVar('interstitial_ad_unit_id'),
            'interstitial_ad_status'    => $interstitial_ad_status,
        ];
        $this->adMobConfigurationModel->save($data);

        return redirect()->to(base_url("dashboard/admob-configuration"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }

}
