<?php

namespace App\Controllers\Auth;
use App\Controllers\BaseController;
use App\Models\Backend\SettingEmailModel;
use App\Models\Backend\UserModel;

class PasswordController extends BaseController
{
	public function __construct()
    {
        $this->userModel = new UserModel();
		$this->settingEmailModel = new SettingEmailModel();
        $this->session = session();
    }
	
	
	
    //=========================================================== //
	public function forgot_password()
	{
        $data['pageTitle'] = lang('Dashboard.forgotPassword');
        return view('\App\Views\auth\forgot_password_view', $data);
	}


	//=========================================================== //
    public function perform_forgot_password()
    {
        // Validate reCAPTCHA
        $recaptchaType = $this->request->getVar('g-recaptcha-type');
        $recaptchaToken = $this->request->getVar('g-recaptcha-response');
        if(!empty($recaptchaType) && !empty($recaptchaToken)) {
            helper('google_recaptcha');
            if (!validateRecaptcha($recaptchaToken, $recaptchaType)) {
                return $this->response->setJSON([
                    //'errors' => ['recaptcha' => 'reCAPTCHA validation failed. Please try again.'],
                    'messageType'       => 'toastr', // sweetalert OR toastr
                    'messageIcon'       => 'error', // success , error , warning , info
                    'messageTitle'      => lang('Dashboard.error'),
                    'messageBody'       => lang('Dashboard.reCAPTCHAValidationFailedPleaseTryAgain'),
                    ])->setStatusCode(400); // 400 Bad Request
            }
        }

        // Validation form
        $rules = [
            'email' => 'required|min_length[6]|max_length[60]|valid_email',
        ];

        $errors = [
            'email' => [
                'required' => lang('Validation.pleaseEnterYourEmailAddress'),
                'min_length' => lang('Validation.theEmailFieldMustBeAtLeastCharactersInLength', [6]),
                'max_length' => lang('Validation.theEmailFieldCannotExceedCharactersInLength', [60]),
                'valid_email' => lang('Validation.yourEmailAddressIsNotValid'),
            ],
        ];

        if (!$this->validate($rules, $errors)) {
            return $this->response->setJSON([
                'messageType'   => 'toastr', // sweetalert OR toastr
                'messageIcon'   => 'error', // success , error , warning , info
                'messageTitle'  => lang('Dashboard.error'),
                'errors'        => $this->validator->getErrors(),
                ])->setStatusCode(400); // 400 Bad Request
        }

        // Valid submission
        // Check if email exists in DB
        $user = $this->userModel->where('email', $this->request->getVar('email'))->first();
        if (! $user) {
            return $this->response->setJSON([
                'messageType' => 'toastr', // sweetalert OR toastr
                'messageIcon' => 'error', // success , error , warning , info
                'messageTitle' => lang('Dashboard.error'),
                'messageBody' => lang('Dashboard.emailAddressNotFoundInSystem'),
                ])->setStatusCode(400); // 400 Bad Request
        }

        // Check if email is already sent to prevent spam
        if (! empty($user->reset_expires) && $user->reset_expires >= time()) {
            return $this->response->setJSON([
                'messageType' => 'toastr', // sweetalert OR toastr
                'messageIcon' => 'info', // success , error , warning , info
                'messageTitle' => lang('Dashboard.info'),
                'messageBody' => lang('Dashboard.anEmailIsAlreadySentToThisAddress'),
                ])->setStatusCode(400); // 400 Bad Request
        }

        // Set reset hash and expiration
        $updatedUser['id'] = $user->id;
        $updatedUser['reset_hash'] = random_string('alnum', 32);
        $updatedUser['reset_expires'] = time() + HOUR;
        $this->userModel->save($updatedUser);

        // Send password reset e-mail
        $settingsEmail = $this->settingEmailModel->select('settings_email_tbl.*')->where('settings_email_tbl.id', 1)->first();
        $subject = lang('Dashboard.passwordResetRequest');
        helper('email');
        @send_password_reset_email($settingsEmail, $this->request->getVar('email'), $subject, $updatedUser['reset_hash']);

        return $this->response->setJSON([
            'messageType' => 'toastr', // sweetalert OR toastr
            'messageIcon' => 'success', // success , error , warning , info
            'messageTitle' => lang('Dashboard.success'),
            'messageBody' => lang('Dashboard.anEmailWithInstructionsIsSentToTheAddress')
        ]);
    }


    //===========================================================//
    public function reset_password()
    {
        // Check reset hash and expiration
        $user = $this->userModel->where('reset_hash', $this->request->getGet('ptoken'))
            ->where('reset_expires >', time())
            ->first();

        if (! $user) {
            return redirect()->to(base_url('auth/forgot-password'))->with('error', lang('Dashboard.invalidResetPasswordRequest'));
        }

        $data['pageTitle'] = lang('Dashboard.resetPassword');
        return view('\App\Views\auth\reset_password_view', $data);
    }


    //===========================================================//
    public function perform_reset_password()
    {
        // Validate reCAPTCHA
        $recaptchaType = $this->request->getVar('g-recaptcha-type');
        $recaptchaToken = $this->request->getVar('g-recaptcha-response');
        if(!empty($recaptchaType) && !empty($recaptchaToken)) {
            helper('google_recaptcha');
            if (!validateRecaptcha($recaptchaToken, $recaptchaType)) {
                return $this->response->setJSON([
                    //'errors' => ['recaptcha' => 'reCAPTCHA validation failed. Please try again.'],
                    'messageType'       => 'toastr', // sweetalert OR toastr
                    'messageIcon'       => 'error', // success , error , warning , info
                    'messageTitle'      => lang('Dashboard.error'),
                    'messageBody'       => lang('Dashboard.reCAPTCHAValidationFailedPleaseTryAgain'),
                    ])->setStatusCode(400); // 400 Bad Request
            }
        }

        // Validate request
        $rules = [
            'ptoken'	=> 'required',
            'password' => 'required|min_length[6]|max_length[120]',
            'confirm_password' => 'matches[password]'
        ];

        $errors = [
            'password' => [
                'required' => lang('Validation.pleaseEnterYourPassword'),
                'min_length' => lang('Validation.thePasswordFieldMustBeAtLeastCharactersInLength', [6]),
                'max_length' => lang('Validation.thePasswordFieldCannotExceedCharactersInLength', [120]),
            ],
            'confirm_password' => [
                'matches' => lang('Validation.yourPasswordFieldsDoesNotMatched'),
            ],
        ];

        if (!$this->validate($rules, $errors)) {
            return $this->response->setJSON([
                'messageType'   => 'toastr', // sweetalert OR toastr
                'messageIcon'   => 'error', // success , error , warning , info
                'messageTitle'  => lang('Dashboard.error'),
                'errors'        => $this->validator->getErrors(),
                ])->setStatusCode(400); // 400 Bad Request
        }

        // Check reset hash, expiration
        $user = $this->userModel->where('reset_hash', $this->request->getVar('ptoken'))
            ->where('reset_expires >', time())
            ->first();

        if (! $user) {
            $this->session->setFlashdata('error', lang('Dashboard.invalidResetPasswordRequest'));
            return $this->response->setJSON([
                'redirectUrl' => base_url('auth/reset-password'),
                'messageType' => 'toastr', // sweetalert OR toastr
                'messageIcon' => 'error', // success , error , warning , info
                'messageTitle' => lang('Dashboard.error'),
                'messageBody' => lang('Dashboard.invalidResetPasswordRequest'),
                ])->setStatusCode(400); // 400 Bad Request
        }

        // Valid submission
        $newData = [
            'id' => $user->id,
            'password' => $this->request->getVar('password'),
            'reset_hash' => null,
            'reset_expires' => null,
        ];
        $this->userModel->save($newData);

        // Redirect to login
        $this->session->setFlashdata('success', lang('Dashboard.passwordUpdateSuccessfully'));
        return $this->response->setJSON([
            'redirectUrl'   => base_url('auth/login'),
            'messageType'   => 'toastr', // sweetalert OR toastr
            'messageIcon'   => 'success', // success , error , warning , info
            'messageTitle'  => lang('Dashboard.success'),
            'messageBody'   => lang('Dashboard.passwordUpdateSuccessfully'),
            'newData'       => $newData,
            ])->setStatusCode(200); // 200 Ok
    }

}
