<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

/* Multi Language: https://stackoverflow.com/questions/60250996/how-to-set-specific-language-for-all-pages-in-codeigniter-4 */
$routes->get('lang/(:any)', 'Language::index');

// Run Cron Task
$routes->get('run-cron-task', 'CronController::run_cron_task');

// Api
$routes->group("api", ["namespace" => "App\Controllers\Api"] , function($routes){
    $routes->group("auth", function($routes){
        $routes->post("perform-login", "ApiController::perform_login");
        $routes->post("perform-register", "ApiController::perform_register");
    });
    $routes->group("user", function($routes){
        $routes->post("user-details", "ApiController::user_details");
        $routes->post("perform-edit-profile-information", "ApiController::perform_edit_profile_information");
        $routes->post("perform-edit-profile-image", "ApiController::perform_edit_profile_image");
        $routes->post("perform-change-password", "ApiController::perform_change_password");
        $routes->post("delete-user", "ApiController::delete_user");
        $routes->post("perform-add-device-info", "ApiController::perform_add_device_info");
    });
    $routes->group("settings", function($routes){
        $routes->post("get-all-settings", "ApiController::get_all_settings");
        $routes->post("get-default-currency-unit", "ApiController::get_default_currency_unit");
    });
    $routes->group("category", function($routes){
        $routes->post("categories-list", "ApiController::categories_list");
    });
    $routes->group("language", function($routes){
        $routes->post("languages-list", "ApiController::languages_list");
    });
    $routes->group("post", function($routes){
        $routes->post("get-all-posts", "ApiController::get_all_posts");
        $routes->post("latest-posts", "ApiController::latest_posts");
        $routes->post("posts-list", "ApiController::posts_list");
        $routes->post("posts-list-by-category", "ApiController::posts_list_by_category");
        $routes->post("post-details", "ApiController::post_details");
        $routes->post("add-comment", "ApiController::add_comment");
        $routes->post("get-comments", "ApiController::get_comments");
    });
    $routes->group("ad", function($routes){
        $routes->post("get-ads", "ApiController::get_ads");
        $routes->post("get-admob-configuration", "ApiController::get_admob_configuration");
        $routes->post('get-tapsell-plus-configuration', 'ApiController::get_tapsell_plus_configuration');
    });
    $routes->group("ad", function($routes){
        $routes->post("get-one-ad", "ApiController::get_one_ad");
    });
    $routes->group("page", function($routes){
        $routes->post("get-pages", "ApiController::get_pages");
        $routes->post("get-one-page", "ApiController::get_one_page");
    });
    $routes->group("slider", function($routes){
        $routes->post("get-images-slider", "ApiController::get_images_slider");
    });
    $routes->group("pc", function($routes){
        $routes->get("show-pc", "ApiController::show_pc");
        $routes->get("show-rtl", "ApiController::show_rtl");
        $routes->get("remove-localkeydata", "ApiController::remove_localkeydata");
        $routes->post("r-pclk", "ApiController::r_pclk");
        $routes->post("r-rtl", "ApiController::r_rtl");
        $routes->post("in-the", "ApiController::in_the");
    });
    $routes->group("version", function($routes){
        $routes->post("get-latest-version", "ApiController::get_latest_version");
        $routes->post("get-versions", "ApiController::get_versions");
    });
});


// Dashboard Auth
$routes->get('login', 'Auth\LoginController::login', ['filter' => 'noauth']);
$routes->group('auth', function($routes)
{
    $routes->get('login', 'Auth\LoginController::login', ['filter' => 'noauth']);
    $routes->post('perform-login', 'Auth\LoginController::perform_login', ['filter' => 'noauth']);
    $routes->get('register', 'Auth\RegisterController::register', ['filter' => 'noauth']);
    $routes->post('perform-register', 'Auth\RegisterController::perform_register', ['filter' => 'noauth']);
    $routes->get('logout', 'Auth\LoginController::logout', ['filter' => 'auth']);
    $routes->get('forgot-password', 'Auth\PasswordController::forgot_password', ['filter' => 'noauth']);
    $routes->post('perform-forgot-password', 'Auth\PasswordController::perform_forgot_password', ['filter' => 'noauth']);
    $routes->get('reset-password', 'Auth\PasswordController::reset_password', ['filter' => 'noauth']);
    $routes->post('perform-reset-password', 'Auth\PasswordController::perform_reset_password', ['filter' => 'noauth']);
    $routes->get('activate-account', 'Auth\RegisterController::activate_account', ['filter' => 'noauth']);
});

// Payment Verification
$routes->get('dashboard/stripe-success', 'Backend\PaymentController::stripe_success');
$routes->get('dashboard/stripe-cancle', 'Backend\PaymentController::stripe_cancle');
$routes->get('dashboard/paypal-success', 'Backend\PaymentController::paypal_success');
$routes->get('dashboard/paypal-cancel', 'Backend\PaymentController::paypal_cancel');
$routes->post('dashboard/paypal-ipn', 'Backend\PaymentController::paypal_ipn');
$routes->get('dashboard/nowpayments-success', 'Backend\PaymentController::nowpayments_success');
$routes->get('dashboard/nowpayments-cancel', 'Backend\PaymentController::nowpayments_cancel');
$routes->post('dashboard/nowpayments-ipn', 'Backend\PaymentController::nowpayments_ipn');
$routes->get('dashboard/flutterwave-verify', 'Backend\PaymentController::flutterwave_verify');

// Dashboard
$routes->group('dashboard', ['filter' => 'auth'], function($routes)
{
    $routes->get('', 'Backend\DashboardController::home');
    $routes->get('home', 'Backend\DashboardController::home');
    $routes->get('test-api', 'Backend\DashboardController::test_api');
    $routes->get('sending-push-notification-from-onesignal', 'Backend\DashboardController::sending_push_notification_from_onesignal');
    $routes->post('perform-sending-push-notification-from-onesignal', 'Backend\DashboardController::perform_sending_push_notification_from_onesignal');
    $routes->post('perform-edit-user-note', 'Backend\DashboardController::perform_edit_user_note');
    $routes->get('sending-newsletter', 'Backend\DashboardController::sending_newsletter');
    $routes->post('perform-sending-newsletter', 'Backend\DashboardController::perform_sending_newsletter');
    $routes->get('sending-email', 'Backend\DashboardController::sending_email');
    $routes->post('perform-sending-email', 'Backend\DashboardController::perform_sending_email');

    $routes->get('profile', 'Backend\UserController::profile');
    $routes->post('perform-update-profile', 'Backend\UserController::perform_update_profile');
    $routes->get('deactivate-profile', 'Backend\UserController::deactivate_profile');
    $routes->post('perform-change-password', 'Backend\UserController::perform_change_password');
    $routes->post('perform-change-image', 'Backend\UserController::perform_change_image');
    $routes->post('perform-update-api-key', 'Backend\UserController::perform_update_api_key');

    $routes->get('general-settings', 'Backend\SettingController::general_settings');
    $routes->post('update-configuration', 'Backend\SettingController::update_configuration');
    $routes->post('update-social-media', 'Backend\SettingController::update_social_media');
    $routes->post('update-third-party-apps', 'Backend\SettingController::update_third_party_apps');
    $routes->post('update-captcha-protection', 'Backend\SettingController::update_captcha_protection');
    $routes->post('update-maintenance-mode', 'Backend\SettingController::update_maintenance_mode');
    $routes->post('update-seo-tools', 'Backend\SettingController::update_seo_tools');
    $routes->get('logo-images', 'Backend\SettingController::logo_images');
    $routes->post('update-dashboard-logo', 'Backend\SettingController::update_dashboard_logo');
    $routes->post('update-light-logo-website', 'Backend\SettingController::update_light_logo_website');
    $routes->post('update-dark-logo-website', 'Backend\SettingController::update_dark_logo_website');
    $routes->post('update-light-logo-mobile', 'Backend\SettingController::update_light_logo_mobile');
    $routes->post('update-dark-logo-mobile', 'Backend\SettingController::update_dark_logo_mobile');
    $routes->post('update-breadcrumbs-image', 'Backend\SettingController::update_breadcrumbs_image');
    $routes->post('update-light-ic-launcher', 'Backend\SettingController::update_light_ic_launcher');
    $routes->post('update-dark-ic-launcher', 'Backend\SettingController::update_dark_ic_launcher');
    $routes->post('update-favicon', 'Backend\SettingController::update_favicon');
    $routes->get('email-settings', 'Backend\SettingController::email_settings');
    $routes->post('perform-email-settings', 'Backend\SettingController::perform_email_settings');
    $routes->get('api-docs', 'Backend\SettingController::api_docs');
    $routes->get('website-templates', 'Backend\SettingController::website_templates');
    $routes->get('select-template/(:any)', 'Backend\SettingController::select_template/$1');
    $routes->get('static-page-terms', 'Backend\SettingController::static_page_terms');
    $routes->post('perform-edit-static-page-terms', 'Backend\SettingController::perform_edit_static_page_terms');
    $routes->get('static-page-privacy', 'Backend\SettingController::static_page_privacy');
    $routes->post('perform-edit-static-page-privacy', 'Backend\SettingController::perform_edit_static_page_privacy');
    $routes->get('static-page-about', 'Backend\SettingController::static_page_about');
    $routes->post('perform-edit-static-page-about', 'Backend\SettingController::perform_edit_static_page_about');
    $routes->get('static-page-advertisement', 'Backend\SettingController::static_page_advertisement');
    $routes->post('perform-edit-static-page-advertisement', 'Backend\SettingController::perform_edit_static_page_advertisement');

    $routes->get('users-list', 'Backend\UserController::users_list');
    $routes->get('soft-deleted-users-list', 'Backend\UserController::soft_deleted_users_list');
    $routes->get('delete-user/(:num)', 'Backend\UserController::delete_user/$1');
    $routes->get('hard-delete-user/(:num)', 'Backend\UserController::hard_delete_user/$1');
    $routes->get('user-restore/(:num)', 'Backend\UserController::user_restore/$1');
    $routes->get('create-new-user', 'Backend\UserController::create_new_user');
    $routes->post('perform-create-new-user', 'Backend\UserController::perform_create_new_user');
    $routes->get('users-activity', 'Backend\UserController::users_activity');
    $routes->get('user-profile/(:num)', 'Backend\UserController::user_profile/$1');
    $routes->post('perform-update-user-profile', 'Backend\UserController::perform_update_user_profile');
    $routes->post('perform-upgrade-user-role', 'Backend\UserController::perform_upgrade_user_role');
    $routes->post('perform-change-user-password', 'Backend\UserController::perform_change_user_password');
    $routes->post('perform-change-user-image', 'Backend\UserController::perform_change_user_image');
    $routes->post('perform-update-user-api-key', 'Backend\UserController::perform_update_user_api_key');
    $routes->get('user-roles', 'Backend\RoleController::user_roles');
    $routes->get('edit-role/(:num)', 'Backend\RoleController::edit_role/$1');
    $routes->post('perform-edit-role', 'Backend\RoleController::perform_edit_role');
    $routes->get('wallet', 'Backend\UserController::wallet');
    $routes->post('perform-add-funds', 'Backend\UserController::perform_add_funds');
    $routes->post('perform-add-funds-to-user-wallet', 'Backend\UserController::perform_add_funds_to_user_wallet');
    $routes->post('perform-withdraw-cash-from-user-wallet', 'Backend\UserController::perform_withdraw_cash_from_user_wallet');
    $routes->get('transactions-list', 'Backend\WalletTransactionController::transactions_list');
    $routes->get('offline-payment', 'Backend\DashboardController::offline_payment');
    $routes->post('perform-offline-payment', 'Backend\DashboardController::perform_offline_payment');
    $routes->get('users-packages', 'Backend\UserController::users_packages');
    $routes->get('edit-users-package/(:num)', 'Backend\UserController::edit_users_package/$1');
    $routes->post('perform-edit-users-package', 'Backend\UserController::perform_edit_users_package');

    $routes->get('create-category', 'Backend\CategoryController::create_category');
    $routes->post('perform-create-category', 'Backend\CategoryController::perform_create_category');
    $routes->get('categories-list', 'Backend\CategoryController::categories_list');
    $routes->get('delete-category/(:num)', 'Backend\CategoryController::delete_category/$1');
    $routes->get('edit-category/(:num)', 'Backend\CategoryController::edit_category/$1');
    $routes->post('perform-edit-category', 'Backend\CategoryController::perform_edit_category');

    $routes->get('languages', 'Backend\LanguageController::languages');
    $routes->post('perform-create-language', 'Backend\LanguageController::perform_create_language');
    $routes->get('update-language/(:num)', 'Backend\LanguageController::update_language/$1');
    $routes->post('perform-update-language', 'Backend\LanguageController::perform_update_language');
    $routes->get('delete-language/(:num)', 'Backend\LanguageController::delete_language/$1');
    
    $routes->get('currency-unit', 'Backend\FinanceAndPaymentController::currency_unit');
    $routes->post('perform-edit-currency-unit', 'Backend\FinanceAndPaymentController::perform_edit_currency_unit');
    $routes->get('payment-gateways', 'Backend\FinanceAndPaymentController::payment_gateways');
    $routes->get('edit-payment-gateway/(:num)', 'Backend\FinanceAndPaymentController::edit_payment_gateway/$1');
    $routes->post('perform-edit-payment-gateway', 'Backend\FinanceAndPaymentController::perform_edit_payment_gateway');
    $routes->get('delete-gateway/(:num)', 'Backend\FinanceAndPaymentController::delete_gateway/$1');
    $routes->get('edit-merchant-key/(:any)', 'Backend\FinanceAndPaymentController::edit_merchant_key/$1');
    $routes->post('perform-edit-merchant-key', 'Backend\FinanceAndPaymentController::perform_edit_merchant_key');
    $routes->get('daily-exchange-rate', 'Backend\FinanceAndPaymentController::daily_exchange_rate');
    $routes->post('perform-edit-daily-exchange-rate', 'Backend\FinanceAndPaymentController::perform_edit_daily_exchange_rate');

    $routes->get('add-post', 'Backend\BlogController::add_post');
    $routes->post('perform-add-post', 'Backend\BlogController::perform_add_post');
    $routes->get('posts-list', 'Backend\BlogController::posts_list');
    $routes->get('soft-deleted-posts-list', 'Backend\BlogController::soft_deleted_posts_list');
    $routes->get('edit-post/(:num)', 'Backend\BlogController::edit_post/$1');
    $routes->post('perform-edit-post', 'Backend\BlogController::perform_edit_post');
    $routes->get('delete-post/(:num)', 'Backend\BlogController::delete_post/$1');
    $routes->get('hard-delete-post/(:num)', 'Backend\BlogController::hard_delete_post/$1');
    $routes->get('post-restore/(:num)', 'Backend\BlogController::post_restore/$1');

    $routes->get('blog-comments-list', 'Backend\BlogController::blog_comments_list');
    $routes->get('deleted-blog-comments-list', 'Backend\BlogController::deleted_blog_comments_list');
    $routes->post('perform-approved-unapproved-blog-comments', 'Backend\BlogController::perform_approve_unapprove_blog_comments');
    $routes->get('delete-blog-comment/(:num)', 'Backend\BlogController::delete_blog_comment/$1');
    $routes->get('restore-blog-comment/(:num)', 'Backend\BlogController::restore_blog_comment/$1');
    $routes->get('hard-delete-blog-comment/(:num)', 'Backend\BlogController::hard_delete_blog_comment/$1');
    $routes->get('edit-blog-comment/(:num)', 'Backend\BlogController::edit_blog_comment/$1');
    $routes->post('perform-edit-blog-comment', 'Backend\BlogController::perform_edit_blog_comment');

    /*$routes->get('pending-blog-comments-list', 'Backend\BlogController::pending_blog_comments_list');
    $routes->get('approved-blog-comments-list', 'Backend\BlogController::approved_blog_comments_list');
    $routes->get('unapproved-blog-comments-list', 'Backend\BlogController::unapproved_blog_comments_list');
    $routes->get('approve-blog-comment/(:num)', 'Backend\BlogController::approve_blog_comment/$1');
    $routes->get('unapproved-blog-comment/(:num)', 'Backend\BlogController::unapproved_blog_comment/$1');*/

    $routes->get('add-page', 'Backend\PageController::add_page');
    $routes->post('perform-add-page', 'Backend\PageController::perform_add_page');
    $routes->get('pages-list', 'Backend\PageController::pages_list');
    $routes->get('edit-page/(:num)', 'Backend\PageController::edit_page/$1');
    $routes->post('perform-edit-page', 'Backend\PageController::perform_edit_page');
    $routes->get('delete-page/(:num)', 'Backend\PageController::delete_page/$1');
    
    $routes->get('add-testimonials', 'Backend\TestimonialsController::add_testimonials');
    $routes->post('perform-add-testimonials', 'Backend\TestimonialsController::perform_add_testimonials');
    $routes->get('testimonials', 'Backend\TestimonialsController::testimonials');
    $routes->get('delete-testimonials/(:num)', 'Backend\TestimonialsController::delete_testimonials/$1');
    $routes->get('edit-testimonials/(:num)', 'Backend\TestimonialsController::edit_testimonials/$1');
    $routes->post('perform-edit-testimonials', 'Backend\TestimonialsController::perform_edit_testimonials');

    $routes->get('create-new-ad', 'Backend\AdController::create_new_ad');
    $routes->post('perform-create-new-ad', 'Backend\AdController::perform_create_new_ad');
    $routes->get('advertising-list', 'Backend\AdController::advertising_list');
    $routes->get('edit-ad/(:num)', 'Backend\AdController::edit_ad/$1');
    $routes->post('perform-edit-ad', 'Backend\AdController::perform_edit_ad');
    $routes->get('delete-ad/(:num)', 'Backend\AdController::delete_ad/$1');
    $routes->get('admob-configuration', 'Backend\AdController::admob_configuration');
    $routes->post('perform-edit-admob-configuration', 'Backend\AdController::perform_edit_admob_configuration');
    $routes->get('tapsell-plus-configuration', 'Backend\AdController::tapsell_plus_configuration');
    $routes->post('perform-edit-tapsell-plus-configuration', 'Backend\AdController::perform_edit_tapsell_plus_configuration');
    

    $routes->get('snippets-list', 'Backend\SettingController::snippets_list');
    $routes->get('edit-snippet/(:num)', 'Backend\SettingController::edit_snippet/$1');
    $routes->post('perform-edit-snippet', 'Backend\SettingController::perform_edit_snippet');

    $routes->get('home-configuration', 'Backend\HomeConfigurationController::home_configuration');
    $routes->post('perform-edit-home-configuration', 'Backend\HomeConfigurationController::perform_edit_home_configuration');

    $routes->get('system-cleanup', 'Backend\SystemController::system_cleanup');
    $routes->post('perform-session-cleanup', 'Backend\SystemController::perform_session_cleanup');
    $routes->post('perform-logs-cleanup', 'Backend\SystemController::perform_logs_cleanup');
    $routes->post('perform-debugbar-cleanup', 'Backend\SystemController::perform_debugbar_cleanup');
    $routes->post('perform-cache-cleanup', 'Backend\SystemController::perform_cache_cleanup');
    $routes->post('perform-users-activity-cleanup', 'Backend\SystemController::perform_users_activity_cleanup');
    $routes->post('perform-downloaded-files-cleanup', 'Backend\SystemController::perform_downloaded_files_cleanup');
    $routes->get('database-status', 'Backend\SystemController::database_status');
    $routes->post('perform-optimise-tables', 'Backend\SystemController::perform_optimise_tables');
    $routes->get('php-info', 'Backend\SystemController::php_info');
    $routes->get('license-information', 'Backend\SystemController::license_information');

    $routes->get('version-control', 'Backend\VersionController::version_control');
    $routes->get('add-version', 'Backend\VersionController::add_version');
    $routes->post('perform-add-version', 'Backend\VersionController::perform_add_version');
    $routes->get('edit-version/(:num)', 'Backend\VersionController::edit_version/$1');
    $routes->post('perform-edit-version', 'Backend\VersionController::perform_edit_version');
    $routes->get('delete-version/(:num)', 'Backend\VersionController::delete_version/$1');
});

// Frontend
$routes->get('/', 'Frontend\HomeController::home');
$routes->get('home', 'Frontend\HomeController::home');
$routes->get('run', 'Frontend\HomeController::run');
$routes->get('unsubscribe-newsletter', 'Frontend\HomeController::unsubscribe_newsletter');
$routes->post('perform-unsubscribe-newsletter', 'Frontend\HomeController::perform_unsubscribe_newsletter');
$routes->get('blog', 'Frontend\BlogController::posts');
$routes->get('post', 'Frontend\BlogController::post'); /* Deep Link */
$routes->get('post-details/(:num)/(:hash)', 'Frontend\BlogController::post_details/$1/$2');
$routes->post('post-comment', 'Frontend\BlogController::post_comment');
$routes->get('tag/(:any)', 'Frontend\BlogController::tag/$1');
$routes->get('category/(:num)/(:any)', 'Frontend\BlogController::category/$1/$2');
$routes->post('add-email-to-newsletter', 'Frontend\BlogController::add_email_to_newsletter');
$routes->get('ad-clicked/(:num)', 'Frontend\HomeController::ad_clicked/$1');
$routes->get('terms-and-conditions', 'Frontend\PageController::terms_and_conditions');
$routes->get('privacy-policy', 'Frontend\PageController::privacy_policy');
$routes->get('about', 'Frontend\PageController::about');
$routes->get('advertisement', 'Frontend\PageController::advertisement');
$routes->get('contact', 'Frontend\PageController::contact');
$routes->post('contact-process', 'Frontend\PageController::contact_process');
$routes->get('page/(:num)/(:hash)', 'Frontend\PageController::page/$1/$2');
$routes->get('mobile-settings', 'Frontend\PageController::mobile_settings');
$routes->get('mobile-languages', 'Frontend\PageController::mobile_languages');
$routes->get('version/(:num)', 'Frontend\PageController::version/$1');